/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.generator;

import com.google.common.base.CaseFormat;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.dmr.ModelType;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.PropertySource;
import org.jboss.logmanager.Level;
import org.wildfly.apigen.generator.GeneratorScope;
import org.wildfly.apigen.generator.Keywords;
import org.wildfly.apigen.generator.ResourceMetaData;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.apigen.invocation.Types;
import org.wildfly.apigen.model.AddressTemplate;
import org.wildfly.apigen.model.ResourceDescription;

public class SourceFactory {
    private static final Logger log = Logger.getLogger(SourceFactory.class.getName());

    public static JavaClassSource createResourceAsClass(ResourceMetaData metaData) {
        String className = Types.javaClassName(metaData.getAddress().getResourceType());
        JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)("public class " + className + " {}"));
        javaClass.setPackage(metaData.get(ResourceMetaData.PKG));
        JavaDocSource javaDoc = javaClass.getJavaDoc();
        ResourceDescription desc = metaData.getDescription();
        javaDoc.setText(desc.getText());
        javaClass.addImport(Address.class);
        javaClass.addImport(Binding.class);
        AnnotationSource addressMeta = javaClass.addAnnotation();
        addressMeta.setName("Address");
        addressMeta.setStringValue(metaData.getAddress().getTemplate());
        desc.getAttributes().forEach(att -> {
            ModelType modelType = ModelType.valueOf((String)att.getValue().get("type").asString());
            Optional<String> resolvedType = Types.resolveJavaTypeName(modelType);
            if (resolvedType.isPresent()) {
                try {
                    PropertySource prop = javaClass.addProperty(resolvedType.get(), Types.javaAttributeName(att.getName()));
                    String attributeDescription = att.getValue().get("description").asString();
                    prop.getMutator().getJavaDoc().setText(attributeDescription);
                    prop.getAccessor().getJavaDoc().setText(attributeDescription);
                    AnnotationSource bindingMeta = prop.getAccessor().addAnnotation();
                    bindingMeta.setName("Binding");
                    bindingMeta.setStringValue("detypedName", att.getName());
                }
                catch (Exception e) {
                    log.log((java.util.logging.Level)Level.ERROR, "Failed to process " + metaData.getAddress() + ", attribute " + att.getName(), e);
                }
            }
        });
        return javaClass;
    }

    public static void createChildAccessors(GeneratorScope scope, ResourceMetaData resourceMetaData, JavaClassSource javaClass) {
        ResourceDescription desc = resourceMetaData.getDescription();
        Set<String> childrenNames = desc.getChildrenNames();
        if (!childrenNames.isEmpty()) {
            javaClass.addImport("java.util.List");
            javaClass.addImport(Subresource.class);
            StringBuffer ctor = new StringBuffer();
            for (String childName : childrenNames) {
                AddressTemplate childAddress = resourceMetaData.getAddress().append(childName + "=*");
                JavaClassSource childClass = scope.getGenerated(childAddress);
                javaClass.addImport((JavaType)childClass);
                String propName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, Keywords.escape(childClass.getName())) + "s";
                String propType = "java.util.List<" + childClass.getName() + ">";
                PropertySource prop = javaClass.addProperty(propType, propName);
                AnnotationSource subresourceMeta = prop.getAccessor().addAnnotation();
                subresourceMeta.setName("Subresource");
                ctor.append("this.").append(propName).append(" = new ").append("java.util.ArrayList<>();\n");
            }
            ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody(ctor.toString());
        }
    }
}

