/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.invocation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import org.wildfly.apigen.invocation.ListTypeAdapter;
import org.wildfly.apigen.invocation.MapTypeAdapter;
import org.wildfly.apigen.invocation.SimpleTypeAdapter;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.apigen.invocation.Types;

public class EntityAdapter<T> {
    private static final DotName BINDING_META = DotName.createSimple((String)Binding.class.getCanonicalName());
    private static final DotName ADDRESS_META = DotName.createSimple((String)Address.class.getCanonicalName());
    private static final DotName SUBRESOURCE_META = DotName.createSimple((String)Subresource.class.getCanonicalName());
    private final Class<?> type;
    private Index index;

    public EntityAdapter(Class<?> type) {
        this.type = type;
        this.createIndex();
    }

    private void createIndex() {
        try {
            Indexer indexer = new Indexer();
            String className = this.getType().getCanonicalName().replace(".", "/") + ".class";
            InputStream stream = this.getType().getClassLoader().getResourceAsStream(className);
            indexer.index(stream);
            this.index = indexer.complete();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize Indexer", e);
        }
    }

    private Class<?> getType() {
        return this.type;
    }

    public boolean isBaseTypeAdapter() {
        return this.isBaseType(this.getType());
    }

    public boolean isBaseType(Class<?> clazz) {
        return clazz == String.class || clazz == Long.class || clazz == Integer.class || clazz == Boolean.class || clazz == Double.class || clazz == BigDecimal.class || clazz == byte[].class;
    }

    private T convertToBaseType(ModelNode dmr) {
        if (this.getType() == String.class) {
            return (T)dmr.asString();
        }
        if (this.getType() == Long.class) {
            return (T)Long.valueOf(dmr.asLong());
        }
        if (this.getType() == Integer.class) {
            return (T)Integer.valueOf(dmr.asInt());
        }
        if (this.getType() == Boolean.class) {
            return (T)Boolean.valueOf(dmr.asBoolean());
        }
        if (this.getType() == Double.class) {
            return (T)Double.valueOf(dmr.asDouble());
        }
        if (this.getType() == BigDecimal.class) {
            return (T)BigDecimal.valueOf(dmr.asDouble());
        }
        if (this.getType() == byte[].class) {
            return (T)dmr.asBytes();
        }
        throw new IllegalArgumentException("Can not convert. This node is not of a base type. Actual type is " + this.type.getName());
    }

    public T fromDMR(ModelNode modelNode) throws Exception {
        if (this.isBaseTypeAdapter()) {
            return this.convertToBaseType(modelNode);
        }
        ModelNode actualPayload = null;
        if (!ModelType.OBJECT.equals((Object)modelNode.getType())) {
            throw new IllegalArgumentException("Unsupported ModelType " + modelNode.getType() + ": " + modelNode);
        }
        actualPayload = modelNode;
        Object entity = this.getType().newInstance();
        ClassInfo clazz = this.index.getClassByName(DotName.createSimple((String)this.getType().getCanonicalName()));
        for (MethodInfo method : clazz.methods()) {
            if (!method.hasAnnotation(BINDING_META)) continue;
            Method getter = entity.getClass().getMethod(method.name(), new Class[0]);
            Class<?> propertyType = getter.getReturnType();
            Binding binding = getter.getDeclaredAnnotation(Binding.class);
            String detypedName = binding.detypedName();
            String javaName = method.name().replace("get", "set");
            ModelNode dmrPayload = actualPayload.get(detypedName);
            ModelType dmrType = Types.resolveModelType(propertyType);
            if (dmrType == ModelType.LIST) {
                new ListTypeAdapter().fromDmr(entity, javaName, dmrType, propertyType, dmrPayload);
                continue;
            }
            if (dmrType == ModelType.OBJECT) {
                new MapTypeAdapter().fromDmr(entity, javaName, dmrType, propertyType, dmrPayload);
                continue;
            }
            new SimpleTypeAdapter().fromDmr(entity, javaName, dmrType, propertyType, dmrPayload);
        }
        return (T)entity;
    }

    public ModelNode fromEntity(T entity) throws Exception {
        ModelNode modelMode = new ModelNode();
        ClassInfo clazz = this.index.getClassByName(DotName.createSimple((String)this.getType().getCanonicalName()));
        for (MethodInfo method : clazz.methods()) {
            if (!method.hasAnnotation(BINDING_META)) continue;
            Method target = entity.getClass().getMethod(method.name(), new Class[0]);
            Class<?> propertyType = target.getReturnType();
            Object propertyValue = target.invoke(entity, new Object[0]);
            Binding binding = target.getDeclaredAnnotation(Binding.class);
            String detypedName = binding.detypedName();
            if (propertyValue == null) continue;
            try {
                ModelType dmrType = Types.resolveModelType(propertyType);
                if (dmrType == ModelType.LIST) {
                    new ListTypeAdapter().toDmr(modelMode, detypedName, (List)propertyValue);
                    continue;
                }
                if (dmrType == ModelType.OBJECT) {
                    new MapTypeAdapter().toDmr(modelMode, detypedName, (Map)propertyValue);
                    continue;
                }
                new SimpleTypeAdapter().toDmr(modelMode, detypedName, dmrType, propertyValue);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed to adopt value " + propertyType.getName(), e);
            }
        }
        return modelMode;
    }
}

