/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.invocation;

import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.jboss.dmr.ModelType;
import org.wildfly.apigen.generator.Keywords;

public class Types<T> {
    private static final Logger logger = Logger.getLogger(Types.class.getName());

    public static Optional<String> resolveJavaTypeName(ModelType modelType) {
        Optional<String> result = Optional.empty();
        if (ModelType.STRING == modelType) {
            result = Optional.of("java.lang.String");
        } else if (ModelType.INT == modelType) {
            result = Optional.of("java.lang.Integer");
        } else if (ModelType.LONG == modelType) {
            result = Optional.of("java.lang.Long");
        } else if (ModelType.BOOLEAN == modelType) {
            result = Optional.of("java.lang.Boolean");
        } else if (ModelType.DOUBLE == modelType) {
            result = Optional.of("java.lang.Double");
        } else {
            logger.warning("Unsupported type " + modelType);
        }
        return result;
    }

    public static final String javaClassName(String dmr) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, dmr.replace("-", "_"));
    }

    public static final String javaAttributeName(String dmr) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, Keywords.escape(dmr.replace("-", "_")));
    }

    public static ModelType resolveModelType(Class<?> javaType) {
        ModelType type = null;
        if (String.class.equals(javaType)) {
            type = ModelType.STRING;
        } else if (Integer.class.equals(javaType)) {
            type = ModelType.INT;
        } else if (Long.class.equals(javaType)) {
            type = ModelType.LONG;
        } else if (Boolean.class.equals(javaType)) {
            type = ModelType.BOOLEAN;
        } else if (Double.class.equals(javaType)) {
            type = ModelType.DOUBLE;
        } else if (List.class.equals(javaType)) {
            type = ModelType.LIST;
        } else if (Map.class.equals(javaType)) {
            type = ModelType.OBJECT;
        } else {
            throw new RuntimeException("Failed to resolve ModelType for '" + javaType.getName() + "'");
        }
        return type;
    }
}

