/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ResourceDescription
extends ModelNode {
    public static final ResourceDescription EMPTY = new ResourceDescription();
    static final String ACCESS_CONTROL = "access-control";
    static final String NOTIFICATIONS = "notifications";

    public ResourceDescription() {
    }

    public ResourceDescription(ModelNode description) {
        this.set(description);
    }

    public boolean hasAttributes() {
        return this.hasDefined("attributes");
    }

    public List<Property> getAttributes() {
        return this.hasAttributes() ? this.get("attributes").asPropertyList() : Collections.EMPTY_LIST;
    }

    public boolean hasAccessControl() {
        return this.hasDefined(ACCESS_CONTROL);
    }

    public boolean hasChildrenDefined() {
        return this.hasDefined("children");
    }

    public boolean hasOperations() {
        return this.hasDefined("operations");
    }

    public boolean hasNotifications() {
        return this.hasDefined(NOTIFICATIONS);
    }

    public Set<String> getChildrenNames() {
        return this.hasChildrenDefined() ? this.get("children").keys() : Collections.EMPTY_SET;
    }

    public ResourceDescription getChildDescription(String resourceName) {
        return this.getChildDescription(resourceName, "*");
    }

    public ResourceDescription getChildDescription(String type, String name) {
        if (this.hasChildrenDefined()) {
            List children = this.get("children").asPropertyList();
            for (Property child : children) {
                if (!type.equals(child.getName()) || !child.getValue().hasDefined("model-description")) continue;
                List modelDescriptions = child.getValue().get("model-description").asPropertyList();
                for (Property modelDescription : modelDescriptions) {
                    if (!name.equals(modelDescription.getName())) continue;
                    return new ResourceDescription(modelDescription.getValue());
                }
            }
        }
        return EMPTY;
    }

    public static ResourceDescription from(ModelNode response) {
        assert (response.get("outcome").asString().equals("success"));
        ModelNode result = response.get("result");
        if (ModelType.LIST == result.getType()) {
            return new ResourceDescription(((ModelNode)result.asList().get(0)).get("result"));
        }
        return new ResourceDescription(result);
    }

    public String getText() {
        return this.get("description").asString();
    }
}

