/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.featurepack.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.build.featurepack.model.FeaturePackBuild;
import org.wildfly.build.pack.model.Config;
import org.wildfly.build.pack.model.ConfigFile;
import org.wildfly.build.pack.model.CopyArtifact;
import org.wildfly.build.pack.model.FileFilter;
import org.wildfly.build.pack.model.FilePermission;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.PropertyResolver;
import org.wildfly.build.util.xml.ParsingUtils;

class FeaturePackBuildModelParser10
implements XMLElementReader<FeaturePackBuild> {
    private final BuildPropertyReplacer propertyReplacer;
    public static final String NAMESPACE_1_0 = "urn:wildfly:feature-pack-build:1.0";

    FeaturePackBuildModelParser10(PropertyResolver resolver) {
        this.propertyReplacer = new BuildPropertyReplacer(resolver);
    }

    public void readElement(XMLExtendedStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int i = 0;
        int count = reader.getAttributeCount();
        if (i < count) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            this.parseDependencies((XMLStreamReader)reader, result);
                            continue block12;
                        }
                        case CONFIG: {
                            this.parseConfig((XMLStreamReader)reader, result.getConfig());
                            continue block12;
                        }
                        case COPY_ARTIFACTS: {
                            this.parseCopyArtifacts((XMLStreamReader)reader, result);
                            continue block12;
                        }
                        case FILE_PERMISSIONS: {
                            this.parseFilePermissions((XMLStreamReader)reader, result);
                            continue block12;
                        }
                        case MKDIRS: {
                            this.parseMkdirs((XMLStreamReader)reader, result);
                            continue block12;
                        }
                        case LINE_ENDINGS: {
                            this.parseLineEndings((XMLStreamReader)reader, result);
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDependencies(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ARTIFACT: {
                            result.getDependencies().add(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return this.propertyReplacer.replaceProperties(name);
    }

    private void parseConfig(XMLStreamReader reader, Config result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case STANDALONE: {
                            this.parseConfigFile(reader, result.getStandaloneConfigFiles());
                            continue block8;
                        }
                        case DOMAIN: {
                            this.parseConfigFile(reader, result.getDomainConfigFiles());
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseConfigFile(XMLStreamReader reader, List<ConfigFile> result) throws XMLStreamException {
        HashMap<String, String> properties = new HashMap<String, String>();
        String template = null;
        String subsystems = null;
        String outputFile = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.TEMPLATE, Attribute.SUBSYSTEMS, Attribute.OUTPUT_FILE);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case TEMPLATE: {
                    template = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case SUBSYSTEMS: {
                    subsystems = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case OUTPUT_FILE: {
                    outputFile = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ConfigFile configFile = new ConfigFile(properties, template, subsystems, outputFile);
        result.add(configFile);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            this.parseProperty(reader, properties);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseProperty(XMLStreamReader reader, Map<String, String> result) throws XMLStreamException {
        String name = null;
        String value = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case VALUE: {
                    value = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        result.put(name, value);
    }

    private void parseCopyArtifacts(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACT: {
                            this.parseCopyArtifact(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseCopyArtifact(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        String artifact = null;
        String location = null;
        boolean extract = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ARTIFACT: {
                    artifact = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case TO_LOCATION: {
                    location = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case EXTRACT: {
                    extract = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        CopyArtifact copyArtifact = new CopyArtifact(artifact, location, extract);
        result.getCopyArtifacts().add(copyArtifact);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, copyArtifact.getFilters());
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseFilter(XMLStreamReader reader, List<FileFilter> filters) throws XMLStreamException {
        String pattern = null;
        boolean include = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        filters.add(new FileFilter(FeaturePackBuildModelParser10.wildcardToJavaRegexp(pattern), include));
    }

    private static String wildcardToJavaRegexp(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        String regex = expr.replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }

    private void parseFilePermissions(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PERMISSION: {
                            this.parsePermission(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parsePermission(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        String permission = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    permission = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        FilePermission filePermission = new FilePermission(permission);
        result.getFilePermissions().add(filePermission);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, filePermission.getFilters());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseMkdirs(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DIR: {
                            result.getMkDirs().add(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEndings(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case WINDOWS: {
                            this.parseLineEnding(reader, result.getWindows());
                            continue block8;
                        }
                        case UNIX: {
                            this.parseLineEnding(reader, result.getUnix());
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEnding(XMLStreamReader reader, List<FileFilter> result) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute {
        UNKNOWN(null),
        NAME("name"),
        VALUE("value"),
        TEMPLATE("template"),
        SUBSYSTEMS("subsystems"),
        OUTPUT_FILE("output-file"),
        ARTIFACT("artifact"),
        TO_LOCATION("to-location"),
        EXTRACT("extract"),
        PATTERN("pattern"),
        INCLUDE("include");

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(TEMPLATE.getLocalName()), TEMPLATE);
            attributesMap.put(new QName(SUBSYSTEMS.getLocalName()), SUBSYSTEMS);
            attributesMap.put(new QName(OUTPUT_FILE.getLocalName()), OUTPUT_FILE);
            attributesMap.put(new QName(VALUE.getLocalName()), VALUE);
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(TO_LOCATION.getLocalName()), TO_LOCATION);
            attributesMap.put(new QName(EXTRACT.getLocalName()), EXTRACT);
            attributesMap.put(new QName(PATTERN.getLocalName()), PATTERN);
            attributesMap.put(new QName(INCLUDE.getLocalName()), INCLUDE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        BUILD("build"),
        DEPENDENCIES("dependencies"),
        ARTIFACT("artifact"),
        CONFIG("config"),
        STANDALONE("standalone"),
        DOMAIN("domain"),
        PROPERTY("property"),
        COPY_ARTIFACTS("copy-artifacts"),
        COPY_ARTIFACT("copy-artifact"),
        FILTER("filter"),
        FILE_PERMISSIONS("file-permissions"),
        PERMISSION("permission"),
        MKDIRS("mkdirs"),
        DIR("dir"),
        LINE_ENDINGS("line-endings"),
        WINDOWS("windows"),
        UNIX("unix");

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, BUILD.getLocalName()), BUILD);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, ARTIFACT.getLocalName()), ARTIFACT);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, STANDALONE.getLocalName()), STANDALONE);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, DOMAIN.getLocalName()), DOMAIN);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, PROPERTY.getLocalName()), PROPERTY);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, COPY_ARTIFACTS.getLocalName()), COPY_ARTIFACTS);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, COPY_ARTIFACT.getLocalName()), COPY_ARTIFACT);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, PERMISSION.getLocalName()), PERMISSION);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, MKDIRS.getLocalName()), MKDIRS);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, DIR.getLocalName()), DIR);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, LINE_ENDINGS.getLocalName()), LINE_ENDINGS);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, WINDOWS.getLocalName()), WINDOWS);
            elementsMap.put(new QName(FeaturePackBuildModelParser10.NAMESPACE_1_0, UNIX.getLocalName()), UNIX);
            elements = elementsMap;
        }
    }
}

