/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.featurepack;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import nu.xom.ParsingException;
import org.jboss.logging.Logger;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.common.model.CopyArtifact;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.featurepack.model.FeaturePackBuild;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePack;
import org.wildfly.build.pack.model.FeaturePackArtifactResolver;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.FeaturePackDescriptionXMLWriter11;
import org.wildfly.build.pack.model.FeaturePackFactory;
import org.wildfly.build.pack.model.ModuleIdentifier;
import org.wildfly.build.util.FileUtils;
import org.wildfly.build.util.ModuleParseResult;
import org.wildfly.build.util.ModuleParser;

public class FeaturePackBuilder {
    private static final Logger logger = Logger.getLogger(FeaturePackBuilder.class);

    public static void build(FeaturePackBuild build, File serverDirectory, ArtifactResolver artifactResolver, ArtifactFileResolver artifactFileResolver) {
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<ModuleIdentifier> knownModules = new HashSet<ModuleIdentifier>();
        HashMap<Artifact.GACE, String> artifactVersionMap = new HashMap<Artifact.GACE, String>();
        FeaturePackDescription featurePackDescription = new FeaturePackDescription(build.getDependencies(), build.getConfig(), build.getCopyArtifacts(), build.getFilePermissions());
        try {
            FeaturePackBuilder.processDependencies(build.getDependencies(), knownModules, new HashSet<String>(), artifactResolver, artifactFileResolver, artifactVersionMap);
            FeaturePackBuilder.processModulesDirectory(knownModules, serverDirectory, artifactResolver, artifactVersionMap, errors);
            FeaturePackBuilder.processVersions(featurePackDescription, artifactResolver, artifactVersionMap);
            FeaturePackBuilder.processContentsDirectory(build, serverDirectory);
            FeaturePackBuilder.writeFeaturePackXml(featurePackDescription, serverDirectory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Some errors were encountered creating the feature pack\n");
                for (String error : errors) {
                    sb.append(error);
                    sb.append("\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
    }

    private static void processDependencies(List<String> dependencies, Set<ModuleIdentifier> knownModules, Set<String> featurePacksProcessed, ArtifactResolver buildArtifactResolver, ArtifactFileResolver artifactFileResolver, Map<Artifact.GACE, String> artifactVersionMap) {
        for (String dependency : dependencies) {
            if (!featurePacksProcessed.add(dependency)) continue;
            Artifact dependencyArtifact = buildArtifactResolver.getArtifact(dependency);
            if (dependencyArtifact == null) {
                dependencyArtifact = buildArtifactResolver.getArtifact(dependency + ":zip");
            }
            if (dependencyArtifact == null) {
                throw new RuntimeException("Could not find artifact for " + dependency);
            }
            FeaturePack dependencyFeaturePack = FeaturePackFactory.createPack((Artifact)dependencyArtifact, (ArtifactFileResolver)artifactFileResolver, (ArtifactResolver)new FeaturePackArtifactResolver(Collections.emptyList()));
            artifactVersionMap.put(dependencyFeaturePack.getArtifact().getGACE(), dependencyFeaturePack.getArtifact().getVersion());
            FeaturePackBuilder.processDependency(dependencyFeaturePack, knownModules, buildArtifactResolver, artifactVersionMap);
        }
    }

    private static void processDependency(FeaturePack dependencyFeaturePack, Set<ModuleIdentifier> knownModules, ArtifactResolver buildArtifactResolver, Map<Artifact.GACE, String> artifactVersionMap) {
        for (Artifact dependencyVersionArtifact : dependencyFeaturePack.getDescription().getArtifactVersions()) {
            Artifact artifact;
            if (artifactVersionMap.containsKey(dependencyVersionArtifact.getGACE()) || (artifact = buildArtifactResolver.getArtifact(dependencyVersionArtifact.getGACE())) == null) continue;
            artifactVersionMap.put(artifact.getGACE(), artifact.getVersion());
        }
        knownModules.addAll(dependencyFeaturePack.getFeaturePackModules().keySet());
        for (FeaturePack featurePack : dependencyFeaturePack.getDependencies()) {
            FeaturePackBuilder.processDependency(featurePack, knownModules, buildArtifactResolver, artifactVersionMap);
        }
    }

    private static void processModulesDirectory(Set<ModuleIdentifier> packProvidedModules, File serverDirectory, final ArtifactResolver artifactResolver, final Map<Artifact.GACE, String> artifactVersionMap, final List<String> errors) throws IOException {
        Path modulesDir = Paths.get(new File(serverDirectory, "modules").getAbsolutePath(), new String[0]);
        if (Files.exists(modulesDir, new LinkOption[0])) {
            final HashSet<ModuleIdentifier> knownModules = new HashSet<ModuleIdentifier>(packProvidedModules);
            final HashMap requiredDepds = new HashMap();
            Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.getFileName().toString().equals("module.xml")) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        ModuleParseResult result = ModuleParser.parse((Path)file);
                        knownModules.add(result.getIdentifier());
                        for (ModuleParseResult.ArtifactName artifactName : result.getArtifacts()) {
                            Artifact artifact = artifactName.hasVersion() ? artifactName.getArtifact() : artifactResolver.getArtifact(artifactName.getArtifactCoords());
                            if (artifact == null) {
                                errors.add("Could not determine version for artifact " + artifactName);
                                continue;
                            }
                            artifactVersionMap.put(artifact.getGACE(), artifact.getVersion());
                        }
                        for (ModuleParseResult.ModuleDependency dep : result.getDependencies()) {
                            if (dep.isOptional()) continue;
                            HashSet<ModuleIdentifier> dependees = (HashSet<ModuleIdentifier>)requiredDepds.get(dep.getModuleId());
                            if (dependees == null) {
                                dependees = new HashSet<ModuleIdentifier>();
                                requiredDepds.put(dep.getModuleId(), dependees);
                            }
                            dependees.add(result.getIdentifier());
                        }
                    }
                    catch (ParsingException e) {
                        throw new RuntimeException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            for (Map.Entry dep : requiredDepds.entrySet()) {
                if (knownModules.contains(dep.getKey())) continue;
                errors.add("Missing module " + dep.getKey() + ". Module was required by " + dep.getValue());
            }
        }
    }

    private static void processVersions(FeaturePackDescription featurePackDescription, ArtifactResolver artifactResolver, Map<Artifact.GACE, String> artifactVersionMap) {
        for (CopyArtifact copyArtifact : featurePackDescription.getCopyArtifacts()) {
            Artifact artifact = artifactResolver.getArtifact(copyArtifact.getArtifact());
            if (artifact == null) {
                throw new RuntimeException("Could not resolve artifact for copy artifact " + copyArtifact.getArtifact());
            }
            artifactVersionMap.put(artifact.getGACE(), artifact.getVersion());
        }
        for (Map.Entry entry : artifactVersionMap.entrySet()) {
            featurePackDescription.getArtifactVersions().add(new Artifact((Artifact.GACE)entry.getKey(), (String)entry.getValue()));
        }
    }

    private static void processContentsDirectory(final FeaturePackBuild build, File serverDirectory) throws IOException {
        File baseDir = new File(serverDirectory, "content");
        for (String dir : build.getMkDirs()) {
            File file = new File(baseDir, dir);
            if (file.isDirectory() || file.mkdirs()) continue;
            throw new RuntimeException("Could not create directory " + file);
        }
        final Path baseDirPath = Paths.get(baseDir.getAbsolutePath(), new String[0]);
        if (!Files.exists(baseDirPath, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(baseDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relative = baseDirPath.relativize(file).toString();
                for (FileFilter fileFilter : build.getUnix()) {
                    if (!fileFilter.matches(relative)) continue;
                    FeaturePackBuilder.toUnixLineEndings(file);
                }
                for (FileFilter fileFilter : build.getWindows()) {
                    if (!fileFilter.matches(relative)) continue;
                    FeaturePackBuilder.toWindowsLineEndings(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void writeFeaturePackXml(FeaturePackDescription featurePackDescription, File serverDirectory) throws IOException, XMLStreamException {
        File outputFile = new File(serverDirectory, "wildfly-feature-pack.xml");
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FeaturePackDescriptionXMLWriter11.INSTANCE.write(featurePackDescription, outputFile);
    }

    private static void toUnixLineEndings(Path file) throws IOException {
        Pattern pattern = Pattern.compile("\\r\\n", 8);
        String content = FileUtils.readFile((File)file.toFile());
        Matcher matcher = pattern.matcher(content);
        content = matcher.replaceAll("\n");
        FileUtils.copyFile((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), (File)file.toFile());
    }

    private static void toWindowsLineEndings(Path file) throws IOException {
        Pattern pattern = Pattern.compile("(?<!\\r)\\n", 8);
        String content = FileUtils.readFile((File)file.toFile());
        Matcher matcher = pattern.matcher(content);
        content = matcher.replaceAll("\r\n");
        FileUtils.copyFile((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), (File)file.toFile());
    }

    static Logger getLog() {
        return logger;
    }
}

