/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.featurepack.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.build.common.model.ConfigModelParser11;
import org.wildfly.build.common.model.CopyArtifactsModelParser10;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.common.model.FileFilterModelParser10;
import org.wildfly.build.common.model.FilePermissionsModelParser10;
import org.wildfly.build.featurepack.model.FeaturePackBuild;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.PropertyResolver;
import org.wildfly.build.util.xml.ParsingUtils;

class FeaturePackBuildModelParser11
implements XMLElementReader<FeaturePackBuild> {
    public static final String NAMESPACE_1_1 = "urn:wildfly:feature-pack-build:1.1";
    private final BuildPropertyReplacer propertyReplacer;
    private final ConfigModelParser11 configModelParser;
    private final CopyArtifactsModelParser10 copyArtifactsModelParser;
    private final FileFilterModelParser10 fileFilterModelParser;
    private final FilePermissionsModelParser10 filePermissionsModelParser;

    FeaturePackBuildModelParser11(PropertyResolver resolver) {
        this.propertyReplacer = new BuildPropertyReplacer(resolver);
        this.configModelParser = new ConfigModelParser11(this.propertyReplacer);
        this.fileFilterModelParser = new FileFilterModelParser10(this.propertyReplacer);
        this.copyArtifactsModelParser = new CopyArtifactsModelParser10(this.propertyReplacer, this.fileFilterModelParser);
        this.filePermissionsModelParser = new FilePermissionsModelParser10(this.propertyReplacer, this.fileFilterModelParser);
    }

    public void readElement(XMLExtendedStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int i = 0;
        int count = reader.getAttributeCount();
        if (i < count) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            this.parseDependencies((XMLStreamReader)reader, result);
                            continue block12;
                        }
                        case CONFIG: {
                            this.configModelParser.parseConfig((XMLStreamReader)reader, result.getConfig());
                            continue block12;
                        }
                        case COPY_ARTIFACTS: {
                            this.copyArtifactsModelParser.parseCopyArtifacts((XMLStreamReader)reader, result.getCopyArtifacts());
                            continue block12;
                        }
                        case FILE_PERMISSIONS: {
                            this.filePermissionsModelParser.parseFilePermissions((XMLStreamReader)reader, result.getFilePermissions());
                            continue block12;
                        }
                        case MKDIRS: {
                            this.parseMkdirs((XMLStreamReader)reader, result);
                            continue block12;
                        }
                        case LINE_ENDINGS: {
                            this.parseLineEndings((XMLStreamReader)reader, result);
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDependencies(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ARTIFACT: {
                            result.getDependencies().add(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return this.propertyReplacer.replaceProperties(name);
    }

    private void parseMkdirs(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DIR: {
                            result.getMkDirs().add(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEndings(XMLStreamReader reader, FeaturePackBuild result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case WINDOWS: {
                            this.parseLineEnding(reader, result.getWindows());
                            continue block8;
                        }
                        case UNIX: {
                            this.parseLineEnding(reader, result.getUnix());
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEnding(XMLStreamReader reader, List<FileFilter> result) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.fileFilterModelParser.parseFilter(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute {
        UNKNOWN(null),
        NAME("name");

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        BUILD("build"),
        DEPENDENCIES("dependencies"),
        ARTIFACT("artifact"),
        CONFIG("config"),
        COPY_ARTIFACTS("copy-artifacts"),
        FILTER("filter"),
        FILE_PERMISSIONS("file-permissions"),
        MKDIRS("mkdirs"),
        DIR("dir"),
        LINE_ENDINGS("line-endings"),
        WINDOWS("windows"),
        UNIX("unix");

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, BUILD.getLocalName()), BUILD);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, ARTIFACT.getLocalName()), ARTIFACT);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, COPY_ARTIFACTS.getLocalName()), COPY_ARTIFACTS);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, MKDIRS.getLocalName()), MKDIRS);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, DIR.getLocalName()), DIR);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, LINE_ENDINGS.getLocalName()), LINE_ENDINGS);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, WINDOWS.getLocalName()), WINDOWS);
            elementsMap.put(new QName(FeaturePackBuildModelParser11.NAMESPACE_1_1, UNIX.getLocalName()), UNIX);
            elements = elementsMap;
        }
    }
}

