/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.configassembly.SubsystemInputStreamSources;
import org.wildfly.build.configassembly.SubsystemParser;
import org.wildfly.build.configassembly.TemplateParser;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;
import org.wildfly.build.util.xml.FormattingXMLStreamWriter;
import org.wildfly.build.util.xml.Node;
import org.wildfly.build.util.xml.ProcessingInstructionNode;

public class ConfigurationAssembler {
    private final SubsystemInputStreamSources subsystemInputStreamSources;
    private final InputStreamSource templateInputStreamSource;
    private final String templateRootElementName;
    private final File outputFile;
    private final Map<String, Map<String, SubsystemConfig>> subsystemConfigs;

    public ConfigurationAssembler(SubsystemInputStreamSources subsystemInputStreamSources, InputStreamSource templateInputStreamSource, String templateRootElementName, Map<String, Map<String, SubsystemConfig>> subsystemConfigs, File outputFile) {
        this.subsystemInputStreamSources = subsystemInputStreamSources;
        this.templateInputStreamSource = templateInputStreamSource;
        this.templateRootElementName = templateRootElementName;
        this.subsystemConfigs = subsystemConfigs;
        this.outputFile = outputFile.getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble() throws IOException, XMLStreamException {
        TemplateParser templateParser = new TemplateParser(this.templateInputStreamSource, this.templateRootElementName);
        templateParser.parse();
        this.populateTemplate(templateParser, this.subsystemConfigs);
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        }
        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
            throw new IllegalStateException("Could not create " + this.outputFile.getParentFile());
        }
        FormattingXMLStreamWriter writer = new FormattingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedWriter(new FileWriter(this.outputFile))));
        try {
            writer.writeStartDocument();
            templateParser.getRootNode().marshall(writer);
            writer.writeEndDocument();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void populateTemplate(TemplateParser templateParser, Map<String, Map<String, SubsystemConfig>> subsystemsConfigs) throws IOException, XMLStreamException {
        TreeSet<String> extensions = new TreeSet<String>();
        HashMap socketBindingsByGroup = new HashMap();
        HashMap outboundSocketBindingsByGroup = new HashMap();
        for (Map.Entry<String, ProcessingInstructionNode> subsystemEntry : templateParser.getSubsystemPlaceholders().entrySet()) {
            String subsystemName = subsystemEntry.getKey();
            String groupName = subsystemEntry.getValue().getDataValue("socket-binding-group", "");
            Map<String, SubsystemConfig> subsystems = subsystemsConfigs.get(subsystemName);
            if (subsystems == null) {
                throw new IllegalStateException("Could not find a subsystems configuration called '" + subsystemEntry.getKey());
            }
            TreeMap<String, ElementNode> socketBindings = new TreeMap<String, ElementNode>();
            if (socketBindingsByGroup.put(groupName, socketBindings) != null) {
                throw new IllegalStateException("Group '" + groupName + "' already exists");
            }
            TreeMap<String, ElementNode> outboundSocketBindings = new TreeMap<String, ElementNode>();
            outboundSocketBindingsByGroup.put(groupName, outboundSocketBindings);
            for (SubsystemConfig subsystem : subsystems.values()) {
                InputStreamSource inputStreamSource = this.subsystemInputStreamSources.getInputStreamSource(subsystem.getSubsystem());
                if (inputStreamSource == null) {
                    throw new IllegalStateException("Could not resolve '" + subsystem);
                }
                SubsystemParser subsystemParser = new SubsystemParser(templateParser.getRootNode().getNamespace(), subsystem.getSupplement(), inputStreamSource);
                subsystemParser.parse();
                subsystemEntry.getValue().addDelegate(subsystemParser.getSubsystem());
                extensions.add(subsystemParser.getExtensionModule());
                for (Map.Entry<String, ElementNode> entry : subsystemParser.getSocketBindings().entrySet()) {
                    if (socketBindings.containsKey(entry.getKey())) {
                        throw new IllegalStateException("SocketBinding '" + entry + "' already exists");
                    }
                    socketBindings.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, ElementNode> entry : subsystemParser.getOutboundSocketBindings().entrySet()) {
                    if (outboundSocketBindings.containsKey(entry.getKey())) {
                        throw new IllegalStateException("Outbound SocketBinding '" + entry + "' already exists");
                    }
                    outboundSocketBindings.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (extensions.size() > 0) {
            ProcessingInstructionNode extensionNode = templateParser.getExtensionPlaceHolder();
            for (String extension : extensions) {
                ElementNode extensionElement = new ElementNode(null, "extension", templateParser.getRootNode().getNamespace());
                extensionElement.addAttribute("module", new AttributeValue(extension));
                extensionNode.addDelegate(extensionElement);
            }
        } else {
            Iterator<Node> it = templateParser.getRootNode().iterateChildren();
            while (it.hasNext()) {
                ElementNode elementNode;
                Node node = it.next();
                if (!(node instanceof ElementNode) || !(elementNode = (ElementNode)node).getName().equals("extensions") && !elementNode.getName().equals("profile")) continue;
                it.remove();
            }
        }
        if (socketBindingsByGroup.size() > 0 && outboundSocketBindingsByGroup.size() > 0) {
            for (Map.Entry<String, ProcessingInstructionNode> entry : templateParser.getSocketBindingsPlaceHolders().entrySet()) {
                Map socketBindings = (Map)socketBindingsByGroup.get(entry.getKey());
                if (socketBindings == null) {
                    throw new IllegalArgumentException("No socket bindings for group " + entry.getKey());
                }
                if (socketBindings.size() <= 0) continue;
                for (ElementNode binding : socketBindings.values()) {
                    entry.getValue().addDelegate(binding);
                }
            }
            for (Map.Entry<String, ProcessingInstructionNode> entry : templateParser.getSocketBindingsPlaceHolders().entrySet()) {
                Map outboundSocketBindings = (Map)outboundSocketBindingsByGroup.get(entry.getKey());
                if (outboundSocketBindings == null) {
                    throw new IllegalArgumentException("No outbound socket bindings for group " + entry.getKey());
                }
                if (outboundSocketBindings.size() <= 0) continue;
                for (ElementNode binding : outboundSocketBindings.values()) {
                    entry.getValue().addDelegate(binding);
                }
            }
        }
    }
}

