/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.wildfly.build.util.InputStreamSource;

public class ZipEntryInputStreamSource
implements InputStreamSource {
    private final File file;
    private final ZipEntry zipEntry;

    public ZipEntryInputStreamSource(File file, ZipEntry zipEntry) {
        this.file = file;
        this.zipEntry = zipEntry;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ZipFile zipFile = new ZipFile(this.file);
        try {
            return new ZipEntryInputStream(zipFile, zipFile.getInputStream(this.zipEntry));
        }
        catch (Throwable t) {
            try {
                zipFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new IOException("failed to retrieve input stream", t);
        }
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private final ZipFile zipFile;
        private final InputStream zipEntryInputStream;

        public ZipEntryInputStream(ZipFile zipFile, InputStream zipEntryInputStream) {
            this.zipFile = zipFile;
            this.zipEntryInputStream = zipEntryInputStream;
        }

        @Override
        public int read() throws IOException {
            return this.zipEntryInputStream.read();
        }

        @Override
        public int available() throws IOException {
            return this.zipEntryInputStream.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.zipEntryInputStream.close();
            }
            finally {
                try {
                    this.zipFile.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.zipEntryInputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.zipEntryInputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.zipEntryInputStream.markSupported();
        }
    }
}

