/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.xml.ElementNode;
import org.wildfly.build.util.xml.NodeParser;
import org.wildfly.build.util.xml.ParsingUtils;
import org.wildfly.build.util.xml.ProcessingInstructionNode;

public class TemplateParser
extends NodeParser {
    private static final String SOCKET_BINDINGS_PI = "SOCKET-BINDINGS";
    private static final String EXTENSIONS_PI = "EXTENSIONS";
    private static final String SUBSYSTEMS_PI = "SUBSYSTEMS";
    private final InputStreamSource inputStreamSource;
    private final String rootElementName;
    private ElementNode root;
    private ProcessingInstructionNode extensionPlaceholder;
    private final Map<String, ProcessingInstructionNode> subsystemPlaceHolders = new HashMap<String, ProcessingInstructionNode>();
    private final Map<String, ProcessingInstructionNode> socketBindingsPlaceHolder = new HashMap<String, ProcessingInstructionNode>();

    public TemplateParser(InputStreamSource inputStreamSource, String rootElementName) {
        this.inputStreamSource = inputStreamSource;
        this.rootElementName = rootElementName;
    }

    public ElementNode getRootNode() {
        return this.root;
    }

    public ProcessingInstructionNode getExtensionPlaceHolder() {
        return this.extensionPlaceholder;
    }

    public Map<String, ProcessingInstructionNode> getSubsystemPlaceholders() {
        return this.subsystemPlaceHolders;
    }

    public Map<String, ProcessingInstructionNode> getSocketBindingsPlaceHolders() {
        return this.socketBindingsPlaceHolder;
    }

    public void parse() throws IOException, XMLStreamException {
        try (InputStream in = this.inputStreamSource.getInputStream();){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader reader = factory.createXMLStreamReader(in);
            reader.require(7, null, null);
            ParsingUtils.getNextElement(reader, this.rootElementName, null, false);
            this.root = super.parseNode(reader, this.rootElementName);
        }
    }

    @Override
    protected ProcessingInstructionNode parseProcessingInstruction(XMLStreamReader reader, ElementNode parent) throws XMLStreamException {
        ProcessingInstructionNode node = null;
        String pi = reader.getPITarget();
        Map<String, String> data = this.parseProcessingInstructionData(reader.getPIData());
        if (pi.equals(EXTENSIONS_PI)) {
            if (!data.isEmpty()) {
                throw new IllegalStateException("<?EXTENSIONS?> should not take any data");
            }
            if (this.extensionPlaceholder != null) {
                throw new IllegalStateException("Can only have one occurrence of <?EXTENSIONS?>");
            }
            this.extensionPlaceholder = node = new ProcessingInstructionNode(EXTENSIONS_PI, null);
        } else if (pi.equals(SUBSYSTEMS_PI)) {
            if (!parent.getName().equals("profile")) {
                throw new IllegalStateException("<?SUBSYSTEMS?> must be a child of <profile> " + reader.getLocation());
            }
            if (data.size() == 0 || !data.containsKey("socket-binding-group")) {
                throw new IllegalStateException("Must have 'socket-binding-group' as <?SUBSYSTEMS?> data");
            }
            if (data.size() > 1) {
                throw new IllegalStateException("Only 'socket-binding-group' is valid <?SUBSYSTEMS?> data");
            }
            String profileName = parent.getAttributeValue("name", "");
            node = new ProcessingInstructionNode(profileName, data);
            this.subsystemPlaceHolders.put(profileName, node);
        } else if (pi.equals(SOCKET_BINDINGS_PI)) {
            if (!parent.getName().equals("socket-binding-group")) {
                throw new IllegalStateException("<?SOCKET-BINDINGS?> must be a child of <socket-binding-group> " + reader.getLocation());
            }
            if (!data.isEmpty()) {
                throw new IllegalStateException("<?SOCKET-BINDINGS?> should not take any data");
            }
            String groupName = parent.getAttributeValue("name", "");
            node = new ProcessingInstructionNode(SOCKET_BINDINGS_PI, data);
            this.socketBindingsPlaceHolder.put(groupName, node);
        } else {
            throw new IllegalStateException("Unknown processing instruction <?" + reader.getPITarget() + "?>" + reader.getLocation());
        }
        return node;
    }
}

