/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.common.model.ConfigFile;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.ModuleIdentifier;
import org.wildfly.build.util.ModuleParseResult;
import org.wildfly.build.util.ModuleParser;
import org.wildfly.build.util.ZipFileSubsystemInputStreamSources;

public class FeaturePack {
    private final File featurePackFile;
    private final Artifact featurePackArtifact;
    private final FeaturePackDescription description;
    private final List<String> configurationFiles;
    private final SortedSet<String> modulesFiles;
    private final List<String> contentFiles;
    private final List<FeaturePack> dependencies;
    private final ArtifactResolver artifactResolver;
    private Map<ModuleIdentifier, Module> featurePackModules;
    private Map<ModuleIdentifier, Module> featurePackAndDependenciesModules;
    private static final String MODULE_XML_ENTRY_NAME_SUFIX = "/module.xml";

    public FeaturePack(File featurePackFile, Artifact featurePackArtifact, FeaturePackDescription description, List<FeaturePack> dependencies, ArtifactResolver artifactResolver, List<String> configurationFiles, List<String> modulesFiles, List<String> contentFiles) {
        this.featurePackFile = featurePackFile;
        this.featurePackArtifact = featurePackArtifact;
        this.description = description;
        this.dependencies = dependencies;
        this.artifactResolver = artifactResolver;
        this.configurationFiles = Collections.unmodifiableList(configurationFiles);
        this.modulesFiles = Collections.unmodifiableSortedSet(new TreeSet<String>(modulesFiles));
        this.contentFiles = Collections.unmodifiableList(contentFiles);
    }

    public FeaturePackDescription getDescription() {
        return this.description;
    }

    public File getFeaturePackFile() {
        return this.featurePackFile;
    }

    public Artifact getArtifact() {
        return this.featurePackArtifact;
    }

    public List<FeaturePack> getDependencies() {
        return this.dependencies;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public List<String> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public SortedSet<String> getModulesFiles() {
        return this.modulesFiles;
    }

    public List<String> getContentFiles() {
        return this.contentFiles;
    }

    public synchronized Map<ModuleIdentifier, Module> getFeaturePackModules() {
        if (this.featurePackModules == null) {
            this.featurePackModules = new HashMap<ModuleIdentifier, Module>();
            try (JarFile jar = new JarFile(this.featurePackFile);){
                for (String moduleFile : this.modulesFiles) {
                    if (!moduleFile.endsWith(MODULE_XML_ENTRY_NAME_SUFIX)) continue;
                    ZipEntry entry = jar.getEntry(moduleFile);
                    ModuleParseResult moduleParseResult = ModuleParser.parse(jar.getInputStream(entry));
                    this.featurePackModules.put(moduleParseResult.getIdentifier(), new Module(this, moduleFile, moduleParseResult));
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to parse feature pack modules from " + this.featurePackFile, e);
            }
            this.featurePackModules = Collections.unmodifiableMap(this.featurePackModules);
        }
        return this.featurePackModules;
    }

    public synchronized Map<ModuleIdentifier, Module> getFeaturePackAndDependenciesModules() {
        if (this.featurePackAndDependenciesModules == null) {
            this.featurePackAndDependenciesModules = new HashMap<ModuleIdentifier, Module>(this.getFeaturePackModules());
            for (FeaturePack dependency : this.dependencies) {
                for (Map.Entry<ModuleIdentifier, Module> entry : dependency.getFeaturePackAndDependenciesModules().entrySet()) {
                    if (this.featurePackAndDependenciesModules.containsKey(entry.getKey())) continue;
                    this.featurePackAndDependenciesModules.put(entry.getKey(), entry.getValue());
                }
            }
            this.featurePackAndDependenciesModules = Collections.unmodifiableMap(this.featurePackAndDependenciesModules);
        }
        return this.featurePackAndDependenciesModules;
    }

    public Module getSubsystemModule(String subsystem, ArtifactFileResolver artifactFileResolver) throws IOException {
        ZipFileSubsystemInputStreamSources inputStreamSources = new ZipFileSubsystemInputStreamSources();
        for (Module module : this.getFeaturePackAndDependenciesModules().values()) {
            if (!inputStreamSources.addSubsystemFileSourceFromModule(subsystem, module, artifactFileResolver)) continue;
            return module;
        }
        return null;
    }

    public Set<String> getSubsystems() throws IOException, XMLStreamException {
        HashSet<String> result = new HashSet<String>();
        for (ConfigFile configFile : this.description.getConfig().getDomainConfigFiles()) {
            for (Map<String, SubsystemConfig> subsystems : configFile.getSubsystemConfigs(this.featurePackFile).values()) {
                result.addAll(subsystems.keySet());
            }
        }
        for (ConfigFile configFile : this.description.getConfig().getStandaloneConfigFiles()) {
            for (Map<String, SubsystemConfig> subsystems : configFile.getSubsystemConfigs(this.featurePackFile).values()) {
                result.addAll(subsystems.keySet());
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturePack that = (FeaturePack)o;
        return this.featurePackFile.equals(that.featurePackFile);
    }

    public int hashCode() {
        return this.featurePackFile.hashCode();
    }

    public static class Module {
        private final FeaturePack featurePack;
        private final String moduleFile;
        private final ModuleParseResult moduleParseResult;

        private Module(FeaturePack featurePack, String moduleFile, ModuleParseResult moduleParseResult) {
            this.featurePack = featurePack;
            this.moduleFile = moduleFile;
            this.moduleParseResult = moduleParseResult;
        }

        public FeaturePack getFeaturePack() {
            return this.featurePack;
        }

        public String getModuleFile() {
            return this.moduleFile;
        }

        public List<String> getModuleDirFiles() {
            String s;
            String moduleDir = this.moduleFile.substring(0, this.moduleFile.length() - FeaturePack.MODULE_XML_ENTRY_NAME_SUFIX.length() + 1);
            ArrayList<String> moduleDirFiles = new ArrayList<String>();
            Iterator iterator = this.featurePack.modulesFiles.tailSet(moduleDir).iterator();
            while (iterator.hasNext() && (s = (String)iterator.next()).startsWith(moduleDir)) {
                if (s.length() <= moduleDir.length() || s.equals(this.moduleFile)) continue;
                moduleDirFiles.add(s);
            }
            return moduleDirFiles;
        }

        public ModuleParseResult getModuleParseResult() {
            return this.moduleParseResult;
        }

        public ModuleIdentifier getIdentifier() {
            return this.moduleParseResult.getIdentifier();
        }

        public Map<ModuleIdentifier, Module> getDependencies() {
            Map<ModuleIdentifier, Module> featurePackAndDependenciesModules = this.featurePack.getFeaturePackAndDependenciesModules();
            HashMap<ModuleIdentifier, Module> result = new HashMap<ModuleIdentifier, Module>();
            ArrayDeque<ModuleParseResult.ModuleDependency> remaining = new ArrayDeque<ModuleParseResult.ModuleDependency>(this.moduleParseResult.getDependencies());
            while (!remaining.isEmpty()) {
                ModuleParseResult.ModuleDependency moduleDependency = (ModuleParseResult.ModuleDependency)remaining.pop();
                ModuleIdentifier moduleIdentifier = moduleDependency.getModuleId();
                Module module = featurePackAndDependenciesModules.get(moduleIdentifier);
                if (module == null) {
                    if (moduleDependency.isOptional()) continue;
                    throw new IllegalStateException("Module " + moduleIdentifier + " not found in feature pack " + this.featurePack + " and dependencies");
                }
                if (result.containsKey(moduleIdentifier)) continue;
                result.put(moduleIdentifier, module);
                remaining.addAll(module.getModuleParseResult().getDependencies());
            }
            return result;
        }
    }
}

