/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

enum Attribute {
    UNKNOWN(null),
    COPY_MODULE_ARTIFACTS("copy-module-artifacts"),
    EXTRACT_SCHEMAS("extract-schemas"),
    PATTERN("pattern"),
    INCLUDE("include"),
    TRANSITIVE("transitive"),
    OUTPUT_FILE("output-file"),
    USE_TEMPLATE("use-template"),
    NAME("name"),
    VALUE("value"),
    GROUP_ID("groupId"),
    ARTIFACT_ID("artifactId"),
    CLASSIFIER("classifier"),
    EXTENSION("extension"),
    VERSION("version");

    private static final Map<QName, Attribute> attributes;
    private final String name;

    static Attribute of(QName qName) {
        Attribute attribute = attributes.get(qName);
        return attribute == null ? UNKNOWN : attribute;
    }

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    static {
        HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
        attributesMap.put(new QName(PATTERN.getLocalName()), PATTERN);
        attributesMap.put(new QName(INCLUDE.getLocalName()), INCLUDE);
        attributesMap.put(new QName(TRANSITIVE.getLocalName()), TRANSITIVE);
        attributesMap.put(new QName(OUTPUT_FILE.getLocalName()), OUTPUT_FILE);
        attributesMap.put(new QName(USE_TEMPLATE.getLocalName()), USE_TEMPLATE);
        attributesMap.put(new QName(NAME.getLocalName()), NAME);
        attributesMap.put(new QName(VALUE.getLocalName()), VALUE);
        attributesMap.put(new QName(COPY_MODULE_ARTIFACTS.getLocalName()), COPY_MODULE_ARTIFACTS);
        attributesMap.put(new QName(EXTRACT_SCHEMAS.getLocalName()), EXTRACT_SCHEMAS);
        attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
        attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
        attributesMap.put(new QName(CLASSIFIER.getLocalName()), CLASSIFIER);
        attributesMap.put(new QName(EXTENSION.getLocalName()), EXTENSION);
        attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
        attributes = attributesMap;
    }
}

