/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wildfly.build.common.model.ConfigOverride;
import org.wildfly.build.common.model.CopyArtifact;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.provisioning.model.ModuleFilter;

public class ServerProvisioningDescription {
    private final List<FeaturePack> featurePacks = new ArrayList<FeaturePack>();
    private final Set<Artifact> versionOverrides = new HashSet<Artifact>();
    private final List<CopyArtifact> copyArtifacts = new ArrayList<CopyArtifact>();
    private boolean copyModuleArtifacts;
    private boolean extractSchemas;
    private Set<String> extractSchemasGroups;

    public ServerProvisioningDescription() {
        this.setExtractSchemasGroups("org.jboss.as org.wildfly");
    }

    public List<FeaturePack> getFeaturePacks() {
        return this.featurePacks;
    }

    public boolean isCopyModuleArtifacts() {
        return this.copyModuleArtifacts;
    }

    public void setCopyModuleArtifacts(boolean copyModuleArtifacts) {
        this.copyModuleArtifacts = copyModuleArtifacts;
    }

    public boolean isExtractSchemas() {
        return this.extractSchemas;
    }

    public void setExtractSchemas(boolean extractSchemas) {
        this.extractSchemas = extractSchemas;
    }

    public Set<String> getExtractSchemasGroups() {
        return this.extractSchemasGroups;
    }

    public String getExtractSchemasGroupsAsString() {
        StringBuilder buffer = new StringBuilder();
        for (String group : this.extractSchemasGroups) {
            buffer.append(group).append(" ");
        }
        return buffer.toString().trim();
    }

    public void setExtractSchemasGroups(String groups) {
        this.extractSchemasGroups = new HashSet<String>(Arrays.asList(groups.split(" ")));
        System.out.println("groups = " + groups);
        System.out.println("groups = " + this.extractSchemasGroups);
    }

    public Set<Artifact> getVersionOverrides() {
        return this.versionOverrides;
    }

    public List<CopyArtifact> getCopyArtifacts() {
        return this.copyArtifacts;
    }

    public static class FeaturePack {
        private final Artifact artifact;
        private ModuleFilters moduleFilters;
        private ConfigOverride configOverride;
        private ContentFilters contentFilters;
        private List<Subsystem> subsystems;

        public FeaturePack(Artifact artifact, ModuleFilters moduleFilters, ConfigOverride configOverride, ContentFilters contentFilters, List<Subsystem> subsystems) {
            this.artifact = artifact;
            this.moduleFilters = moduleFilters;
            this.configOverride = configOverride;
            this.contentFilters = contentFilters;
            this.subsystems = subsystems;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public ModuleFilters getModuleFilters() {
            return this.moduleFilters;
        }

        public void setModuleFilters(ModuleFilters moduleFilters) {
            this.moduleFilters = moduleFilters;
        }

        public ConfigOverride getConfigOverride() {
            return this.configOverride;
        }

        public void setConfigOverride(ConfigOverride configOverride) {
            this.configOverride = configOverride;
        }

        public ContentFilters getContentFilters() {
            return this.contentFilters;
        }

        public void setContentFilters(ContentFilters contentFilters) {
            this.contentFilters = contentFilters;
        }

        public List<Subsystem> getSubsystems() {
            return this.subsystems;
        }

        public void setSubsystems(List<Subsystem> subsystems) {
            this.subsystems = subsystems;
        }

        public boolean includesContentFiles() {
            return this.configOverride == null && this.subsystems == null && this.moduleFilters == null || this.contentFilters != null;
        }

        public static class Subsystem {
            private final String name;
            private final boolean transitive;

            public Subsystem(String name, boolean transitive) {
                this.name = name;
                this.transitive = transitive;
            }

            public String getName() {
                return this.name;
            }

            public boolean isTransitive() {
                return this.transitive;
            }

            public String toString() {
                return this.getName();
            }
        }

        public static class ContentFilters {
            private final List<FileFilter> filters = new ArrayList<FileFilter>();
            private final boolean include;

            public ContentFilters(boolean include) {
                this.include = include;
            }

            public List<FileFilter> getFilters() {
                return this.filters;
            }

            public boolean isInclude() {
                return this.include;
            }
        }

        public static class ModuleFilters {
            private final List<ModuleFilter> filters = new ArrayList<ModuleFilter>();
            private final boolean include;

            public ModuleFilters(boolean include) {
                this.include = include;
            }

            public List<ModuleFilter> getFilters() {
                return this.filters;
            }

            public boolean isInclude() {
                return this.include;
            }
        }
    }
}

