/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wildfly.build.provisioning.model;

import org.jboss.staxmapper.XMLMapper;
import org.wildfly.build.util.PropertyResolver;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.io.InputStream;

/**
 * @author Eduardo Martins
 */
public class ServerProvisioningDescriptionModelParser {

    private static final QName ROOT_1_0 = new QName(ServerProvisioningDescriptionModelParser10.NAMESPACE_1_0, Element.SERVER_PROVISIONING.getLocalName());
    private static final QName ROOT_1_1 = new QName(ServerProvisioningDescriptionModelParser11.NAMESPACE_1_1, Element.SERVER_PROVISIONING.getLocalName());

    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();

    private final XMLMapper mapper;

    public ServerProvisioningDescriptionModelParser(PropertyResolver properties) {
        mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(ROOT_1_0, new ServerProvisioningDescriptionModelParser10(properties));
        mapper.registerRootElement(ROOT_1_1, new ServerProvisioningDescriptionModelParser11(properties));
    }

    public ServerProvisioningDescription parse(final InputStream input) throws XMLStreamException {

        final XMLInputFactory inputFactory = INPUT_FACTORY;
        setIfSupported(inputFactory, XMLInputFactory.IS_VALIDATING, Boolean.FALSE);
        setIfSupported(inputFactory, XMLInputFactory.SUPPORT_DTD, Boolean.FALSE);
        final XMLStreamReader streamReader = inputFactory.createXMLStreamReader(input);
        ServerProvisioningDescription serverProvisioningDescription = new ServerProvisioningDescription();
        mapper.parseDocument(serverProvisioningDescription, streamReader);
        return serverProvisioningDescription;
    }

    private void setIfSupported(final XMLInputFactory inputFactory, final String property, final Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

}
