/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.MapPropertyResolver;
import org.wildfly.build.util.PropertyResolver;

public class SubsystemsParser {
    static String NAMESPACE = "urn:subsystems-config:1.0";

    public static void parse(InputStreamSource inputStreamSource, Map<String, Map<String, SubsystemConfig>> result) throws IOException, XMLStreamException {
        SubsystemsParser.parse(inputStreamSource, new BuildPropertyReplacer(PropertyResolver.NO_OP), result);
    }

    public static void parse(InputStreamSource inputStreamSource, Map<String, String> properties, Map<String, Map<String, SubsystemConfig>> result) throws IOException, XMLStreamException {
        SubsystemsParser.parse(inputStreamSource, new BuildPropertyReplacer(new MapPropertyResolver(properties)), result);
    }

    public static void parse(InputStreamSource inputStreamSource, BuildPropertyReplacer propertyReplacer, Map<String, Map<String, SubsystemConfig>> result) throws IOException, XMLStreamException {
        try (InputStream in = inputStreamSource.getInputStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            reader.require(7, null, null);
            boolean done = false;
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!done && reader.getLocalName().equals("config")) {
                            SubsystemsParser.parseConfig(reader, propertyReplacer, result);
                            done = true;
                            break;
                        }
                        throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
    }

    public static void parseConfig(XMLStreamReader reader, BuildPropertyReplacer propertyReplacer, Map<String, Map<String, SubsystemConfig>> result) throws XMLStreamException {
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (reader.getLocalName().equals("subsystems")) {
                        SubsystemsParser.parseSubsystems(reader, propertyReplacer, result);
                        break;
                    }
                    throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (!reader.getLocalName().equals("config")) break;
                    return;
                }
            }
        }
    }

    public static void parseSubsystems(XMLStreamReader reader, BuildPropertyReplacer propertyReplacer, Map<String, Map<String, SubsystemConfig>> result) throws XMLStreamException {
        String name = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!reader.getAttributeLocalName(i).equals("name")) {
                throw new XMLStreamException("Unknown attribute " + reader.getAttributeLocalName(i), reader.getLocation());
            }
            name = propertyReplacer.replaceProperties(reader.getAttributeValue(i));
        }
        if (result.containsKey(name)) {
            throw new XMLStreamException("Already have a subsystems named " + name, reader.getLocation());
        }
        LinkedHashMap<String, SubsystemConfig> subsystems = new LinkedHashMap<String, SubsystemConfig>();
        SubsystemsParser.parseSubsystem(reader, propertyReplacer, subsystems);
        result.put(name, subsystems);
    }

    private static void parseSubsystem(XMLStreamReader reader, BuildPropertyReplacer propertyReplacer, Map<String, SubsystemConfig> subsystems) throws XMLStreamException {
        reader.next();
        block4: while (true) {
            switch (reader.getEventType()) {
                case 1: {
                    if (reader.getLocalName().equals("subsystem")) {
                        String supplement = null;
                        String systemProperty = null;
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            String attr = reader.getAttributeLocalName(i);
                            if (attr.equals("supplement")) {
                                supplement = propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                                continue;
                            }
                            if (attr.equals("include-if-set")) {
                                systemProperty = reader.getAttributeValue(i);
                                continue;
                            }
                            throw new XMLStreamException("Unknown attribute " + attr, reader.getLocation());
                        }
                        if (supplement != null && supplement.isEmpty()) {
                            supplement = null;
                        }
                        String text = reader.getElementText();
                        if (systemProperty != null) {
                            if (System.getProperty(systemProperty) == null) continue block4;
                            subsystems.put(text, new SubsystemConfig(text, supplement));
                            continue block4;
                        }
                        subsystems.put(text, new SubsystemConfig(text, supplement));
                        continue block4;
                    }
                    throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (!reader.getLocalName().equals("subsystems")) break;
                    return;
                }
            }
            reader.next();
        }
    }
}

