/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.configassembly.SubsystemInputStreamSources;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePack;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.ModuleParseResult;
import org.wildfly.build.util.ZipEntryInputStreamSource;

public class ZipFileSubsystemInputStreamSources
implements SubsystemInputStreamSources {
    private final Map<String, ZipEntryInputStreamSource> inputStreamSourceMap = new HashMap<String, ZipEntryInputStreamSource>();

    public void addSubsystemFileSource(String subsystemFileName, File zipFile, ZipEntry zipEntry) {
        this.inputStreamSourceMap.put(subsystemFileName, new ZipEntryInputStreamSource(zipFile, zipEntry));
    }

    public void addAllSubsystemFileSources(ZipFileSubsystemInputStreamSources other) {
        for (Map.Entry<String, ZipEntryInputStreamSource> entry : other.inputStreamSourceMap.entrySet()) {
            if (this.inputStreamSourceMap.containsKey(entry.getKey())) continue;
            this.inputStreamSourceMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void addAllSubsystemFileSourcesFromZipFile(File file) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            if (zip.getEntry("subsystem-templates") != null) {
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String entryName;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(entryName = entry.getName()).startsWith("subsystem-templates/")) continue;
                    this.addSubsystemFileSource(entryName.substring("subsystem-templates/".length()), file, entry);
                }
            }
        }
    }

    public boolean addSubsystemFileSourceFromZipFile(String subsystem, File file) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            String entryName = "subsystem-templates/" + subsystem;
            ZipEntry entry = zip.getEntry(entryName);
            if (entry != null) {
                this.addSubsystemFileSource(subsystem, file, entry);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void addAllSubsystemFileSourcesFromModule(FeaturePack.Module module, ArtifactFileResolver artifactFileResolver, boolean transitive) throws IOException {
        for (ModuleParseResult.ArtifactName artifactName : module.getModuleParseResult().getArtifacts()) {
            Artifact artifact = module.getFeaturePack().getArtifactResolver().getArtifact(artifactName.getArtifactCoords());
            if (artifact == null) {
                throw new RuntimeException("Could not resolve module resource artifact " + artifactName.getArtifactCoords() + " for feature pack " + module.getFeaturePack().getFeaturePackFile());
            }
            File artifactFile = artifactFileResolver.getArtifactFile(artifact);
            this.addAllSubsystemFileSourcesFromZipFile(artifactFile);
        }
        if (transitive) {
            for (FeaturePack.Module dependency : module.getDependencies().values()) {
                this.addAllSubsystemFileSourcesFromModule(dependency, artifactFileResolver, false);
            }
        }
    }

    public boolean addSubsystemFileSourceFromModule(String subsystem, FeaturePack.Module module, ArtifactFileResolver artifactFileResolver) throws IOException {
        for (ModuleParseResult.ArtifactName artifactName : module.getModuleParseResult().getArtifacts()) {
            Artifact artifact = module.getFeaturePack().getArtifactResolver().getArtifact(artifactName.getArtifactCoords());
            if (artifact == null) {
                throw new RuntimeException("Could not resolve module resource artifact " + artifactName.getArtifactCoords() + " for feature pack " + module.getFeaturePack().getFeaturePackFile());
            }
            File artifactFile = artifactFileResolver.getArtifactFile(artifact);
            if (!this.addSubsystemFileSourceFromZipFile(subsystem, artifactFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStreamSource getInputStreamSource(String subsystemFileName) {
        return this.inputStreamSourceMap.get(subsystemFileName);
    }

    public String toString() {
        return "zip subsystem parser factory files: " + this.inputStreamSourceMap.keySet();
    }
}

