/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.common.model.Config;
import org.wildfly.build.common.model.ConfigFile;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.xml.ParsingUtils;

public class ConfigModelParser10 {
    public static final String ELEMENT_LOCAL_NAME = "config";
    private final BuildPropertyReplacer propertyReplacer;

    public ConfigModelParser10(BuildPropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    public void parseConfig(XMLStreamReader reader, Config result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case STANDALONE: {
                            this.parseConfigFile(reader, result.getStandaloneConfigFiles());
                            continue block8;
                        }
                        case DOMAIN: {
                            this.parseConfigFile(reader, result.getDomainConfigFiles());
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseConfigFile(XMLStreamReader reader, List<ConfigFile> result) throws XMLStreamException {
        HashMap<String, String> properties = new HashMap<String, String>();
        String template = null;
        String subsystems = null;
        String outputFile = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.TEMPLATE, Attribute.SUBSYSTEMS, Attribute.OUTPUT_FILE);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case TEMPLATE: {
                    template = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case SUBSYSTEMS: {
                    subsystems = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case OUTPUT_FILE: {
                    outputFile = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ConfigFile configFile = new ConfigFile(properties, template, subsystems, outputFile);
        result.add(configFile);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            this.parseProperty(reader, properties);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseProperty(XMLStreamReader reader, Map<String, String> result) throws XMLStreamException {
        String name = null;
        String value = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case VALUE: {
                    value = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        result.put(name, value);
    }

    static enum Attribute {
        UNKNOWN(null),
        TEMPLATE("template"),
        SUBSYSTEMS("subsystems"),
        OUTPUT_FILE("output-file"),
        NAME("name"),
        VALUE("value");

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>();
            attributesMap.put(TEMPLATE.getLocalName(), TEMPLATE);
            attributesMap.put(SUBSYSTEMS.getLocalName(), SUBSYSTEMS);
            attributesMap.put(OUTPUT_FILE.getLocalName(), OUTPUT_FILE);
            attributesMap.put(NAME.getLocalName(), NAME);
            attributesMap.put(VALUE.getLocalName(), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        STANDALONE("standalone"),
        DOMAIN("domain"),
        PROPERTY("property"),
        HOST("host");

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Element> elementsMap = new HashMap<String, Element>();
            elementsMap.put(STANDALONE.getLocalName(), STANDALONE);
            elementsMap.put(DOMAIN.getLocalName(), DOMAIN);
            elementsMap.put(PROPERTY.getLocalName(), PROPERTY);
            elements = elementsMap;
        }
    }
}

