/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.common.model.FileFilterModelParser10;
import org.wildfly.build.common.model.FilePermission;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.xml.ParsingUtils;

public class FilePermissionsModelParser10 {
    public static final String ELEMENT_LOCAL_NAME = "file-permissions";
    private final BuildPropertyReplacer propertyReplacer;
    private final FileFilterModelParser10 fileFilterModelParser;

    public FilePermissionsModelParser10(BuildPropertyReplacer propertyReplacer) {
        this(propertyReplacer, new FileFilterModelParser10(propertyReplacer));
    }

    public FilePermissionsModelParser10(BuildPropertyReplacer propertyReplacer, FileFilterModelParser10 fileFilterModelParser) {
        this.propertyReplacer = propertyReplacer;
        this.fileFilterModelParser = fileFilterModelParser;
    }

    public void parseFilePermissions(XMLStreamReader reader, List<FilePermission> result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PERMISSION: {
                            this.parsePermission(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    protected void parsePermission(XMLStreamReader reader, List<FilePermission> result) throws XMLStreamException {
        String permission = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    permission = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        FilePermission filePermission = new FilePermission(permission);
        result.add(filePermission);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.fileFilterModelParser.parseFilter(reader, filePermission.getFilters());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    static enum Attribute {
        UNKNOWN(null),
        VALUE("value");

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>();
            attributesMap.put(VALUE.getLocalName(), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        PERMISSION("permission"),
        FILTER("filter");

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Element> elementsMap = new HashMap<String, Element>();
            elementsMap.put(PERMISSION.getLocalName(), PERMISSION);
            elementsMap.put(FILTER.getLocalName(), FILTER);
            elements = elementsMap;
        }
    }
}

