/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;

public class DelegatingArtifactResolver
implements ArtifactResolver {
    private final List<ArtifactResolver> resolvers = new ArrayList<ArtifactResolver>();

    public DelegatingArtifactResolver(ArtifactResolver ... resolvers) {
        this.resolvers.addAll(Arrays.asList(resolvers));
    }

    @Override
    public Artifact getArtifact(Artifact coords) {
        for (ArtifactResolver resolver : this.resolvers) {
            Artifact res = resolver.getArtifact(coords);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

