/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.common.model.CopyArtifact;
import org.wildfly.build.common.model.FileFilterModelParser10;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.xml.ParsingUtils;

public class CopyArtifactsModelParser10 {
    public static final String ELEMENT_LOCAL_NAME = "copy-artifacts";
    private final BuildPropertyReplacer propertyReplacer;
    private final FileFilterModelParser10 fileFilterModelParser;

    public CopyArtifactsModelParser10(BuildPropertyReplacer propertyReplacer) {
        this(propertyReplacer, new FileFilterModelParser10(propertyReplacer));
    }

    public CopyArtifactsModelParser10(BuildPropertyReplacer propertyReplacer, FileFilterModelParser10 fileFilterModelParser) {
        this.propertyReplacer = propertyReplacer;
        this.fileFilterModelParser = fileFilterModelParser;
    }

    public void parseCopyArtifacts(XMLStreamReader reader, List<CopyArtifact> result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACT: {
                            this.parseCopyArtifact(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseCopyArtifact(XMLStreamReader reader, List<CopyArtifact> result) throws XMLStreamException {
        String artifact = null;
        String toLocation = null;
        String fromLocation = null;
        boolean extract = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ARTIFACT: {
                    artifact = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block13;
                }
                case TO_LOCATION: {
                    toLocation = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block13;
                }
                case FROM_LOCATION: {
                    fromLocation = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block13;
                }
                case EXTRACT: {
                    extract = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block13;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        CopyArtifact copyArtifact = new CopyArtifact(artifact, toLocation, extract, fromLocation);
        result.add(copyArtifact);
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.fileFilterModelParser.parseFilter(reader, copyArtifact.getFilters());
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    static enum Attribute {
        UNKNOWN(null),
        ARTIFACT("artifact"),
        TO_LOCATION("to-location"),
        FROM_LOCATION("from-location"),
        EXTRACT("extract");

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>();
            attributesMap.put(ARTIFACT.getLocalName(), ARTIFACT);
            attributesMap.put(TO_LOCATION.getLocalName(), TO_LOCATION);
            attributesMap.put(FROM_LOCATION.getLocalName(), FROM_LOCATION);
            attributesMap.put(EXTRACT.getLocalName(), EXTRACT);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        COPY_ARTIFACT("copy-artifact"),
        FILTER("filter");

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Element> elementsMap = new HashMap<String, Element>();
            elementsMap.put(COPY_ARTIFACT.getLocalName(), COPY_ARTIFACT);
            elementsMap.put(FILTER.getLocalName(), FILTER);
            elements = elementsMap;
        }
    }
}

