/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wildfly.build.util;

import org.wildfly.build.configassembly.SubsystemInputStreamSources;

import java.io.File;

/**
 * @author Eduardo Martins
 */
public class BaseDirSubsystemInputStreamSources implements SubsystemInputStreamSources {

    private final File baseDir;

    public BaseDirSubsystemInputStreamSources(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public InputStreamSource getInputStreamSource(String subsystemFileName) {
        final File subsystemFile = new File(baseDir, subsystemFileName);
        return new FileInputStreamSource(subsystemFile);
    }

}
