/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.pack.model.ModuleIdentifier;
import org.wildfly.build.util.InputStreamSource;

class ModuleParser {
    private final InputStreamSource inputStreamSource;
    List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();

    ModuleParser(InputStreamSource inputStreamSource) {
        this.inputStreamSource = inputStreamSource;
    }

    List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    void parse() throws IOException, XMLStreamException {
        try (InputStream in = this.inputStreamSource.getInputStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            reader.require(7, null, null);
            boolean done = false;
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!done && reader.getLocalName().equals("module")) {
                            this.parseModule(reader);
                            done = true;
                            break;
                        }
                        if (done || !reader.getLocalName().equals("module-alias")) break;
                        this.parseModuleAlias(reader);
                        done = true;
                        break;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
    }

    private void parseModule(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (!reader.getLocalName().equals("dependencies")) break;
                    this.parseDependencies(reader);
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("module")) break;
                    return;
                }
            }
        }
    }

    private void parseModuleAlias(XMLStreamReader reader) throws XMLStreamException {
        String name = "";
        String slot = "main";
        boolean optional = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals("target-name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (!localName.equals("target-slot")) continue;
            slot = reader.getAttributeValue(i);
        }
        ModuleIdentifier moduleId = new ModuleIdentifier(name, slot);
        this.dependencies.add(new ModuleDependency(moduleId, optional));
    }

    private void parseDependencies(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (!reader.getLocalName().equals("module")) break;
                    String name = "";
                    String slot = "main";
                    boolean optional = false;
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String localName = reader.getAttributeLocalName(i);
                        if (localName.equals("name")) {
                            name = reader.getAttributeValue(i);
                            continue;
                        }
                        if (localName.equals("slot")) {
                            slot = reader.getAttributeValue(i);
                            continue;
                        }
                        if (!localName.equals("optional")) continue;
                        optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    }
                    ModuleIdentifier moduleId = new ModuleIdentifier(name, slot);
                    this.dependencies.add(new ModuleDependency(moduleId, optional));
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("dependencies")) break;
                    return;
                }
            }
        }
    }

    static class ModuleDependency {
        private final ModuleIdentifier moduleId;
        private final boolean optional;

        ModuleDependency(ModuleIdentifier moduleId, boolean optional) {
            this.moduleId = moduleId;
            this.optional = optional;
        }

        ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "[" + this.moduleId + (this.optional ? ",optional=true" : "") + "]";
        }
    }
}

