/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;

public class FeaturePackArtifactResolver
implements ArtifactResolver {
    private final Map<String, Artifact> artifactMap = new HashMap<String, Artifact>();

    public FeaturePackArtifactResolver(Collection<Artifact> artifactVersions) {
        for (Artifact artifact : artifactVersions) {
            StringBuilder sb = new StringBuilder();
            sb.append(artifact.getGACE().getGroupId());
            sb.append(':');
            sb.append(artifact.getGACE().getArtifactId());
            if (artifact.getGACE().getClassifier() != null && !artifact.getGACE().getClassifier().isEmpty()) {
                this.artifactMap.put(sb.append("::").append(artifact.getGACE().getClassifier()).toString(), artifact);
                continue;
            }
            this.artifactMap.put(sb.toString(), artifact);
        }
    }

    @Override
    public Artifact getArtifact(String artifactCoords) {
        return this.artifactMap.get(artifactCoords);
    }

    @Override
    public Artifact getArtifact(Artifact.GACE GACE2) {
        StringBuilder sb = new StringBuilder();
        sb.append(GACE2.getGroupId());
        sb.append(':');
        sb.append(GACE2.getArtifactId());
        if (GACE2.getClassifier() != null) {
            sb.append("::").append(GACE2.getClassifier());
        }
        return this.getArtifact(sb.toString());
    }
}

