/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.wildfly.build.pack.model.ModuleIdentifier;
import org.wildfly.build.util.ModuleParseResult;

public class ModuleParser {
    public static ModuleParseResult parse(Path inputFile) throws IOException, ParsingException {
        return ModuleParser.parse(new BufferedInputStream(new FileInputStream(inputFile.toFile())));
    }

    public static ModuleParseResult parse(InputStream in) throws IOException, ParsingException {
        Document document;
        Builder builder = new Builder(false);
        try (InputStream in1 = in;){
            document = builder.build(in1);
        }
        ModuleParseResult result = new ModuleParseResult(document);
        Element rootElement = document.getRootElement();
        if (rootElement.getLocalName().equals("module-alias")) {
            ModuleParser.parseModuleAlias(rootElement, result);
        } else if (rootElement.getLocalName().equals("module")) {
            ModuleParser.parseModule(rootElement, result);
        }
        return result;
    }

    private static void parseModule(Element element, ModuleParseResult result) {
        Element resources;
        Element dependencies;
        String name = element.getAttributeValue("name");
        String slot = ModuleParser.getOptionalAttributeValue(element, "slot", "main");
        result.identifier = new ModuleIdentifier(name, slot);
        Attribute versionAttribute = element.getAttribute("version");
        if (versionAttribute != null) {
            result.versionArtifactName = ModuleParser.parseOptionalArtifactName(versionAttribute.getValue(), versionAttribute);
        }
        if ((dependencies = element.getFirstChildElement("dependencies", element.getNamespaceURI())) != null) {
            ModuleParser.parseDependencies(dependencies, result);
        }
        if ((resources = element.getFirstChildElement("resources", element.getNamespaceURI())) != null) {
            ModuleParser.parseResources(resources, result);
        }
    }

    private static String getOptionalAttributeValue(Element element, String name, String defVal) {
        String value = element.getAttributeValue(name);
        return value == null ? defVal : value;
    }

    private static void parseModuleAlias(Element element, ModuleParseResult result) {
        String targetName = ModuleParser.getOptionalAttributeValue(element, "target-name", "");
        String targetSlot = ModuleParser.getOptionalAttributeValue(element, "target-slot", "main");
        String name = element.getAttributeValue("name");
        String slot = ModuleParser.getOptionalAttributeValue(element, "slot", "main");
        ModuleIdentifier moduleId = new ModuleIdentifier(targetName, targetSlot);
        result.identifier = new ModuleIdentifier(name, slot);
        result.dependencies.add(new ModuleParseResult.ModuleDependency(moduleId, false));
    }

    private static void parseDependencies(Element element, ModuleParseResult result) {
        Elements modules = element.getChildElements("module", element.getNamespaceURI());
        int size = modules.size();
        for (int i = 0; i < size; ++i) {
            Element moduleElement = modules.get(i);
            String name = ModuleParser.getOptionalAttributeValue(moduleElement, "name", "");
            String slot = ModuleParser.getOptionalAttributeValue(moduleElement, "slot", "main");
            boolean optional = Boolean.parseBoolean(ModuleParser.getOptionalAttributeValue(moduleElement, "optional", "false"));
            ModuleIdentifier moduleId = new ModuleIdentifier(name, slot);
            result.dependencies.add(new ModuleParseResult.ModuleDependency(moduleId, optional));
        }
    }

    private static void parseResources(Element element, ModuleParseResult result) {
        Elements children = element.getChildElements();
        int size = children.size();
        block8: for (int i = 0; i < size; ++i) {
            Element child = children.get(i);
            switch (child.getLocalName()) {
                case "resource-root": {
                    String path = child.getAttributeValue("path");
                    if (path == null) continue block8;
                    result.resourceRoots.add(path);
                    continue block8;
                }
                case "artifact": {
                    Attribute attribute = child.getAttribute("name");
                    if (attribute == null) continue block8;
                    String nameStr = attribute.getValue();
                    result.artifacts.add(ModuleParser.parseArtifactName(nameStr, attribute));
                    continue block8;
                }
            }
        }
    }

    private static ModuleParseResult.ArtifactName parseArtifactName(String artifactName, Attribute attribute) {
        ModuleParseResult.ArtifactName name = ModuleParser.parseOptionalArtifactName(artifactName, attribute);
        if (name == null) {
            return new ModuleParseResult.ArtifactName(artifactName, null, attribute);
        }
        return name;
    }

    private static ModuleParseResult.ArtifactName parseOptionalArtifactName(String artifactName, Attribute attribute) {
        if (artifactName.startsWith("${") && artifactName.endsWith("}")) {
            String ct = artifactName.substring(2, artifactName.length() - 1);
            String options = null;
            String artifactCoords = ct;
            if (ct.contains("?")) {
                String[] split = ct.split("\\?");
                options = split[1];
                artifactCoords = split[0];
            }
            return new ModuleParseResult.ArtifactName(artifactCoords, options, attribute);
        }
        return null;
    }
}

