/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import org.wildfly.build.logger.ProvisioningLogger;

public class Artifact
implements Comparable<Artifact> {
    private final GACE GACE;
    private String version;

    public Artifact(String groupId, String artifactId, String classifier, String extension, String version) {
        this(new GACE(groupId, artifactId, classifier, extension), version);
    }

    public Artifact(GACE GACE2, String version) {
        if (GACE2 == null) {
            throw new IllegalArgumentException("null gac");
        }
        this.GACE = GACE2;
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("null or empty version");
        }
        this.version = version;
    }

    public GACE getGACE() {
        return this.GACE;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static Artifact parse(String description) {
        String[] parts = description.split(":");
        switch (parts.length) {
            case 3: {
                return new Artifact(parts[0], parts[1], null, "jar", parts[2]);
            }
            case 5: {
                return new Artifact(parts[0], parts[1], parts[3], parts[2], parts[4]);
            }
        }
        throw ProvisioningLogger.ROOT_LOGGER.cannotParseArtifact(description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        if (!this.GACE.equals(artifact.GACE)) {
            return false;
        }
        return this.version.equals(artifact.version);
    }

    public int hashCode() {
        int result = this.GACE.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    @Override
    public int compareTo(Artifact o) {
        int result = this.GACE.compareTo(o.GACE);
        if (result == 0) {
            result = this.version.compareTo(o.version);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.GACE.groupId).append(':').append(this.GACE.artifactId);
        if (this.GACE.extension != null || this.GACE.classifier != null) {
            sb.append(':');
            if (this.GACE.extension != null) {
                sb.append(this.GACE.extension);
            }
            sb.append(':');
            if (this.GACE.classifier != null) {
                sb.append(this.GACE.classifier);
            }
        }
        sb.append(':').append(this.version);
        return sb.toString();
    }

    public static class GACE
    implements Comparable<GACE> {
        private final String groupId;
        private final String artifactId;
        private final String classifier;
        private final String extension;

        public GACE(String groupId, String artifactId, String classifier, String extension) {
            if (groupId == null) {
                throw new IllegalArgumentException("null groupId");
            }
            this.groupId = groupId;
            if (artifactId == null) {
                throw new IllegalArgumentException("null artifactId");
            }
            this.artifactId = artifactId;
            this.classifier = classifier != null && !classifier.isEmpty() ? classifier : null;
            this.extension = extension != null && !extension.equals("jar") ? extension : null;
        }

        public static String canonicalize(String description) {
            return org.wildfly.build.pack.model.Artifact$GACE.parse(description).toString();
        }

        public static GACE parse(String description) {
            String[] parts = description.split(":");
            switch (parts.length) {
                case 2: {
                    return new GACE(parts[0], parts[1], null, null);
                }
                case 3: {
                    return new GACE(parts[0], parts[1], null, parts[2]);
                }
                case 4: {
                    return new GACE(parts[0], parts[1], parts[3], parts[2]);
                }
            }
            throw ProvisioningLogger.ROOT_LOGGER.cannotParseArtifact(description);
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GACE GACE2 = (GACE)o;
            if (!this.groupId.equals(GACE2.groupId)) {
                return false;
            }
            if (!this.artifactId.equals(GACE2.artifactId)) {
                return false;
            }
            if (this.classifier != null ? !this.classifier.equals(GACE2.classifier) : GACE2.classifier != null) {
                return false;
            }
            return !(this.extension != null ? !this.extension.equals(GACE2.extension) : GACE2.extension != null);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
            result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(GACE o) {
            int result = this.groupId.compareTo(o.groupId);
            if (result == 0 && (result = this.artifactId.compareTo(o.artifactId)) == 0) {
                if (this.classifier != null) {
                    result = o.classifier == null ? 1 : this.classifier.compareTo(o.classifier);
                } else if (o.classifier != null) {
                    result = -1;
                }
                if (result == 0) {
                    if (this.extension != null) {
                        result = o.extension == null ? 1 : this.extension.compareTo(o.extension);
                    } else if (o.extension != null) {
                        result = -1;
                    }
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.groupId).append(':').append(this.artifactId);
            if (this.extension != null) {
                sb.append(':').append(this.extension);
                if (this.classifier != null) {
                    sb.append(':').append(this.classifier);
                }
            } else if (this.classifier != null) {
                sb.append("::").append(this.classifier);
            }
            return sb.toString();
        }
    }
}

