# RHOASK Test
We need to set up an instance of RHOSAK and provide the test with the RHOSAK credentials.

You will need the [rhoas](https://github.com/redhat-developer/app-services-cli/releases) CLI tool.
This is updated quite frequently, so make sure you are on the latest release.

While Kafka instances, Service Accounts, topics and ACLS can be set up in the RHOSAK console accessible from https://developers.redhat.com/products/red-hat-openshift-streams-for-apache-kafka/getting-started,
we will do it via the `rhoas` CLI.

First make sure you are logged in:
```shell
$ rhoas login
```

We then create a Kafka instance with default values. Names of Kafka instances must be unique on the RHOSAK server, s
o call it `<your-name>-kafka`. In my case that is `kabir-kafka` and what will be used for the rest of these instructions:
```shell
rhoas kafka create --name kabir-kafka
```
This will take a few minutes. Once the `Status` of `rhoas context status kafka` is `ready` we can proceed to the next step.

Next we tell `rhoas` to use our Kafka instance. All future commands with `rhoas` will be for the instance. Additionally,
we create a topic called `testing`.

```shell
$ rhoas context set-kafka --name kabir-kafka
$ rhoas kafka topic create --name testing
```

Next we save the configuration to connect to Kafka. This also creates a Service Account behind the scenes. The information is
contained in the rhoas.env file:
```shell
$ rhoas generate-config --type env 
$ cat rhoas.env
## Generated by rhoas cli
## Kafka Configuration
KAFKA_HOST=kabir-kafk-ca-gkal-d-cv--s-j-ka.bf2.kafka.rhcloud.com:443

## Authentication Configuration
RHOAS_CLIENT_ID=srvc-acct-XXXXXX-XXXXX-XXXXXX-XXXX-XXXXXXXX
RHOAS_CLIENT_SECRET=XXXXXX-XXXXX-XXXXXX-XXXX-XXXXXXXX
RHOAS_OAUTH_TOKEN_URL=https://identity.api.openshift.com/auth/realms/rhoas/protocol/openid-connect/token
```

The final step on the `rhoas` side is to set up permission so our associated Service Account has permissions to read from
and write to topics on the Kafka instance. Substitute `<RHOAS_CLIENT_ID>` with the value from your local copy of the `rhoas.env` file:
```shell
$ rhoas kafka acl grant-access --producer --consumer --topic all --group all --service-account srvc-acct-XXXXXX-XXXXX-XXXXXX-XXXX-XXXXXXXX 

-- SNIP --

? Are you sure you want to create the listed ACL rules? Yes

✔️  ACLs successfully created in the Kafka instance "kabir-kafka"

```
We add the secret to our OpenShift instance by running the following command:
```shell
kubectl create secret generic rhoas --from-env-file=./rhoas.env                                                                            
```
The name of the secret is inferred from the name of the file, so it becomes `rhoas`.

To run the test, run:

```shell
$ mvn clean install -Pmanual-rhosak -pl tests/manual/rhosak/
```

## CI Setup
The workflow yaml enables this test if the following env vars are defined in the base 64 encoded input:
* KAFKA_HOST 
* RHOAS_CLIENT_ID
* RHOAS_CLIENT_SECRET

In all cases these are the values from the rhoas.env file we created above.


