/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.os;

import java.io.File;
import java.security.AccessController;

public final class Process {
    private static final long processId;
    private static final String processName;

    private Process() {
    }

    public static String getProcessName() {
        return processName;
    }

    public static long getProcessId() {
        return processId;
    }

    static {
        Object[] array = AccessController.doPrivileged(() -> {
            ProcessHandle processHandle = ProcessHandle.current();
            long pid = processHandle.pid();
            String processName = System.getProperty("jboss.process.name");
            if (processName == null) {
                String classPath = System.getProperty("java.class.path");
                String commandLine = System.getProperty("sun.java.command");
                if (commandLine != null) {
                    if (classPath != null && commandLine.startsWith(classPath)) {
                        int sepIdx = classPath.lastIndexOf(File.separatorChar);
                        processName = sepIdx > 0 ? classPath.substring(sepIdx + 1) : classPath;
                    } else {
                        int firstSpace = commandLine.indexOf(32);
                        String className = firstSpace > 0 ? commandLine.substring(0, firstSpace) : commandLine;
                        int lastDot = className.lastIndexOf(46, firstSpace);
                        if (lastDot > 0) {
                            processName = className.substring(lastDot + 1);
                            if (processName.equalsIgnoreCase("jar") || processName.equalsIgnoreCase("\u0237ar")) {
                                int lastSep;
                                int secondLastDot = className.lastIndexOf(46, lastDot - 1);
                                int sepIdx = className.lastIndexOf(File.separatorChar);
                                int n = secondLastDot == -1 ? sepIdx : (lastSep = sepIdx == -1 ? secondLastDot : Math.max(sepIdx, secondLastDot));
                                processName = lastSep > 0 ? className.substring(lastSep + 1) : className;
                            }
                        } else {
                            processName = className;
                        }
                    }
                }
            }
            if (processName == null) {
                processName = processHandle.info().command().orElse(null);
            }
            if (processName == null) {
                processName = "<unknown>";
            }
            return new Object[]{pid, processName};
        });
        processId = (Long)array[0];
        processName = (String)array[1];
    }
}

