package org.wildfly.common._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.security.PrivilegedActionException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.wildfly.common.codec.DecodeException;
import java.lang.Exception;
import java.lang.NullPointerException;
import java.lang.Object;
import java.util.Arrays;
import java.lang.ArrayIndexOutOfBoundsException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2019-02-11T09:49:08-0600")
public class CommonMessages_$bundle implements CommonMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected CommonMessages_$bundle() {}
    public static final CommonMessages_$bundle INSTANCE = new CommonMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String nullParam = "Parameter '%s' may not be null";
    protected String nullParam$str() {
        return nullParam;
    }
    @Override
    public final IllegalArgumentException nullParam(final String paramName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullParam$str(), paramName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String paramLessThan = "COM00001: Parameter '%s' must not be less than %d";
    protected String paramLessThan$str() {
        return paramLessThan;
    }
    @Override
    public final IllegalArgumentException paramLessThan(final String name, final long min) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramLessThan$str(), name, min));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final IllegalArgumentException paramLessThan(final String name, final double min) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramLessThan$str(), name, min));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String paramGreaterThan = "COM00002: Parameter '%s' must not be greater than than %d";
    protected String paramGreaterThan$str() {
        return paramGreaterThan;
    }
    @Override
    public final IllegalArgumentException paramGreaterThan(final String name, final long max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramGreaterThan$str(), name, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final IllegalArgumentException paramGreaterThan(final String name, final double max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramGreaterThan$str(), name, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String arrayOffsetGreaterThanLength = "COM00003: Given offset of %d is greater than array length of %d";
    protected String arrayOffsetGreaterThanLength$str() {
        return arrayOffsetGreaterThanLength;
    }
    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetGreaterThanLength(final int offs, final int arrayLength) {
        final ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(getLoggingLocale(), arrayOffsetGreaterThanLength$str(), offs, arrayLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String arrayOffsetLengthGreaterThanLength = "COM00004: Given offset of %d plus length of %d is greater than array length of %d";
    protected String arrayOffsetLengthGreaterThanLength$str() {
        return arrayOffsetLengthGreaterThanLength;
    }
    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetLengthGreaterThanLength(final int offs, final int len, final int arrayLength) {
        final ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(getLoggingLocale(), arrayOffsetLengthGreaterThanLength$str(), offs, len, arrayLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullArrayParam = "COM00005: Array index %d of parameter '%s' may not be null";
    protected String nullArrayParam$str() {
        return nullArrayParam;
    }
    @Override
    public final IllegalArgumentException nullArrayParam(final int index, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullArrayParam$str(), index, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullParamNPE = "COM00006: Parameter '%s' may not be null";
    protected String nullParamNPE$str() {
        return nullParamNPE;
    }
    @Override
    public final NullPointerException nullParamNPE(final String name) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullParamNPE$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionAction = "COM00007: Invalid permission action '%s'";
    protected String invalidPermissionAction$str() {
        return invalidPermissionAction;
    }
    @Override
    public final IllegalArgumentException invalidPermissionAction(final String action) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermissionAction$str(), action));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyParam = "COM00008: Parameter '%s' must not be empty";
    protected String emptyParam$str() {
        return emptyParam;
    }
    @Override
    public final IllegalArgumentException emptyParam(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParam$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidExpressionSyntax = "COM00009: Invalid expression syntax at position %d";
    protected String invalidExpressionSyntax$str() {
        return invalidExpressionSyntax;
    }
    @Override
    public final String invalidExpressionSyntax(final int index) {
        return String.format(getLoggingLocale(), invalidExpressionSyntax$str(), index);
    }
    private static final String unresolvedEnvironmentProperty = "COM00010: No environment property found named \"%s\"";
    protected String unresolvedEnvironmentProperty$str() {
        return unresolvedEnvironmentProperty;
    }
    @Override
    public final IllegalArgumentException unresolvedEnvironmentProperty(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unresolvedEnvironmentProperty$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unresolvedSystemProperty = "COM00011: No system property found named \"%s\"";
    protected String unresolvedSystemProperty$str() {
        return unresolvedSystemProperty;
    }
    @Override
    public final IllegalArgumentException unresolvedSystemProperty(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unresolvedSystemProperty$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAddressBytes = "COM00012: Invalid address length of %d; must be 4 or 16";
    protected String invalidAddressBytes$str() {
        return invalidAddressBytes;
    }
    @Override
    public final IllegalArgumentException invalidAddressBytes(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAddressBytes$str(), length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAddress = "COM00013: Invalid address string \"%s\"";
    protected String invalidAddress$str() {
        return invalidAddress;
    }
    @Override
    public final IllegalArgumentException invalidAddress(final String address) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAddress$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupported = "COM00100: Method \"%s\" of class \"%s\" is not implemented";
    protected String unsupported$str() {
        return unsupported;
    }
    @Override
    public final UnsupportedOperationException unsupported(final String methodName, final String className) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupported$str(), methodName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String privilegedActionFailed = "COM00200: Privileged action failed";
    protected String privilegedActionFailed$str() {
        return privilegedActionFailed;
    }
    @Override
    public final PrivilegedActionException privilegedActionFailed(final Exception e) {
        final PrivilegedActionException result = new PrivilegedActionException(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readOnlyPermissionCollection = "COM00300: Permission collection is read-only";
    protected String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionType = "COM00301: Invalid permission type (expected %s, actual value was %s)";
    protected String invalidPermissionType$str() {
        return invalidPermissionType;
    }
    @Override
    public final IllegalArgumentException invalidPermissionType(final Class<? extends java.security.Permission> expectedType, final Class<? extends java.security.Permission> actualType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermissionType$str(), expectedType, actualType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOddFields = "COM00400: Invalid serialized remote exception cause object with odd number of strings in fields key/value list";
    protected String invalidOddFields$str() {
        return invalidOddFields;
    }
    @Override
    public final IllegalStateException invalidOddFields() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidOddFields$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotContainNullFieldNameOrValue = "COM00401: Field name or field value cannot be null";
    protected String cannotContainNullFieldNameOrValue$str() {
        return cannotContainNullFieldNameOrValue;
    }
    @Override
    public final IllegalArgumentException cannotContainNullFieldNameOrValue() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotContainNullFieldNameOrValue$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String corruptedStream = "COM00402: Remote exception stream is corrupted and cannot be read";
    protected String corruptedStream$str() {
        return corruptedStream;
    }
    @Override
    public final IOException corruptedStream() {
        final IOException result = new IOException(String.format(getLoggingLocale(), corruptedStream$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteException2 = "Remote exception %s: %s";
    protected String remoteException2$str() {
        return remoteException2;
    }
    @Override
    public final String remoteException(final String exceptionClassName, final String message) {
        return String.format(getLoggingLocale(), remoteException2$str(), exceptionClassName, message);
    }
    private static final String remoteException1 = "Remote exception %s";
    protected String remoteException1$str() {
        return remoteException1;
    }
    @Override
    public final String remoteException(final String exceptionClassName) {
        return String.format(getLoggingLocale(), remoteException1$str(), exceptionClassName);
    }
    private static final String unexpectedPadding = "COM00500: Unexpected padding";
    protected String unexpectedPadding$str() {
        return unexpectedPadding;
    }
    @Override
    public final DecodeException unexpectedPadding() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), unexpectedPadding$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedPadding = "COM00501: Expected padding";
    protected String expectedPadding$str() {
        return expectedPadding;
    }
    @Override
    public final DecodeException expectedPadding() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedPadding$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteDecode = "COM00502: Incomplete decode";
    protected String incompleteDecode$str() {
        return incompleteDecode;
    }
    @Override
    public final DecodeException incompleteDecode() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), incompleteDecode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedPaddingCharacters = "COM00503: Expected %d padding characters";
    protected String expectedPaddingCharacters$str() {
        return expectedPaddingCharacters;
    }
    @Override
    public final DecodeException expectedPaddingCharacters(final int numExpected) {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedPaddingCharacters$str(), numExpected));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBase32Character = "COM00504: Invalid base 32 character";
    protected String invalidBase32Character$str() {
        return invalidBase32Character;
    }
    @Override
    public final DecodeException invalidBase32Character() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), invalidBase32Character$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedEvenNumberOfHexCharacters = "COM00505: Expected an even number of hex characters";
    protected String expectedEvenNumberOfHexCharacters$str() {
        return expectedEvenNumberOfHexCharacters;
    }
    @Override
    public final DecodeException expectedEvenNumberOfHexCharacters() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedEvenNumberOfHexCharacters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHexCharacter = "COM00506: Invalid hex character";
    protected String invalidHexCharacter$str() {
        return invalidHexCharacter;
    }
    @Override
    public final DecodeException invalidHexCharacter() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), invalidHexCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedTwoPaddingCharacters = "COM00507: Expected two padding characters";
    protected String expectedTwoPaddingCharacters$str() {
        return expectedTwoPaddingCharacters;
    }
    @Override
    public final DecodeException expectedTwoPaddingCharacters() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedTwoPaddingCharacters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBase64Character = "COM00508: Invalid base 64 character";
    protected String invalidBase64Character$str() {
        return invalidBase64Character;
    }
    @Override
    public final DecodeException invalidBase64Character() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), invalidBase64Character$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooLarge = "COM00509: Byte string builder is too large to grow";
    protected String tooLarge$str() {
        return tooLarge;
    }
    @Override
    public final IllegalStateException tooLarge() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedNullValue = "COM01000: Internal error: Assertion failure: Unexpectedly null value";
    protected String unexpectedNullValue$str() {
        return unexpectedNullValue;
    }
    @Override
    public final String unexpectedNullValue() {
        return String.format(getLoggingLocale(), unexpectedNullValue$str());
    }
    private static final String expectedLockHold = "COM01001: Internal error: Assertion failure: Current thread expected to hold lock for %s";
    protected String expectedLockHold$str() {
        return expectedLockHold;
    }
    @Override
    public final String expectedLockHold(final Object monitor) {
        return String.format(getLoggingLocale(), expectedLockHold$str(), monitor);
    }
    private static final String expectedLockNotHold = "COM01002: Internal error: Assertion failure: Current thread expected to not hold lock for %s";
    protected String expectedLockNotHold$str() {
        return expectedLockNotHold;
    }
    @Override
    public final String expectedLockNotHold(final Object monitor) {
        return String.format(getLoggingLocale(), expectedLockNotHold$str(), monitor);
    }
    private static final String expectedBoolean = "COM01003: Internal error: Assertion failure: Expected boolean value to be %s";
    protected String expectedBoolean$str() {
        return expectedBoolean;
    }
    @Override
    public final String expectedBoolean(final boolean expr) {
        return String.format(getLoggingLocale(), expectedBoolean$str(), expr);
    }
    private static final String unreachableCode = "COM02000: Internal error: Unreachable code has been reached";
    protected String unreachableCode$str() {
        return unreachableCode;
    }
    @Override
    public final IllegalStateException unreachableCode() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unreachableCode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String impossibleSwitchCase = "COM02001: Internal error: Impossible switch condition encountered: %s";
    protected String impossibleSwitchCase$str() {
        return impossibleSwitchCase;
    }
    @Override
    public final IllegalStateException impossibleSwitchCase(final Object cond) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), impossibleSwitchCase$str(), cond));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
