package org.wildfly.swarm.config.ee;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.ee.subsystem.managedThreadFactory.ManagedThreadFactory;
import org.wildfly.swarm.config.ee.subsystem.contextService.ContextService;
import org.wildfly.swarm.config.ee.subsystem.managedExecutorService.ManagedExecutorService;
import org.wildfly.swarm.config.ee.subsystem.managedScheduledExecutorService.ManagedScheduledExecutorService;
import org.wildfly.swarm.config.ee.subsystem.service.DefaultBindings;
/**
 * The configuration of the EE subsystem.
 */
@Address("/subsystem=ee")
@Implicit
public class Ee<T extends Ee> {

	private String key;
	private Boolean annotationPropertyReplacement;
	private Boolean earSubdeploymentsIsolated;
	private List<java.util.Map> globalModules;
	private Boolean jbossDescriptorPropertyReplacement;
	private Boolean specDescriptorPropertyReplacement;
	private EeResources subresources = new EeResources();
	private DefaultBindings defaultBindings;

	public Ee() {
		this.key = "ee";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Flag indicating whether Java EE annotations will have property replacements applied
	 */
	@ModelNodeBinding(detypedName = "annotation-property-replacement")
	public Boolean annotationPropertyReplacement() {
		return this.annotationPropertyReplacement;
	}

	/**
	 * Flag indicating whether Java EE annotations will have property replacements applied
	 */
	@SuppressWarnings("unchecked")
	public T annotationPropertyReplacement(Boolean value) {
		this.annotationPropertyReplacement = value;
		return (T) this;
	}

	/**
	 * Flag indicating whether each of the subdeployments within a .ear can access classes belonging to another subdeployment within the same .ear. A value of false means the subdeployments can see classes belonging to other subdeployments within the .ear.
	 */
	@ModelNodeBinding(detypedName = "ear-subdeployments-isolated")
	public Boolean earSubdeploymentsIsolated() {
		return this.earSubdeploymentsIsolated;
	}

	/**
	 * Flag indicating whether each of the subdeployments within a .ear can access classes belonging to another subdeployment within the same .ear. A value of false means the subdeployments can see classes belonging to other subdeployments within the .ear.
	 */
	@SuppressWarnings("unchecked")
	public T earSubdeploymentsIsolated(Boolean value) {
		this.earSubdeploymentsIsolated = value;
		return (T) this;
	}

	/**
	 * A list of modules that should be made available to all deployments.
	 */
	@ModelNodeBinding(detypedName = "global-modules")
	public List<Map> globalModules() {
		return this.globalModules;
	}

	/**
	 * A list of modules that should be made available to all deployments.
	 */
	@SuppressWarnings("unchecked")
	public T globalModules(List<java.util.Map> value) {
		this.globalModules = value;
		return (T) this;
	}

	/**
	 * Flag indicating whether JBoss specific deployment descriptors will have property replacements applied
	 */
	@ModelNodeBinding(detypedName = "jboss-descriptor-property-replacement")
	public Boolean jbossDescriptorPropertyReplacement() {
		return this.jbossDescriptorPropertyReplacement;
	}

	/**
	 * Flag indicating whether JBoss specific deployment descriptors will have property replacements applied
	 */
	@SuppressWarnings("unchecked")
	public T jbossDescriptorPropertyReplacement(Boolean value) {
		this.jbossDescriptorPropertyReplacement = value;
		return (T) this;
	}

	/**
	 * Flag indicating whether descriptors defined by the Java EE specification will have property replacements applied
	 */
	@ModelNodeBinding(detypedName = "spec-descriptor-property-replacement")
	public Boolean specDescriptorPropertyReplacement() {
		return this.specDescriptorPropertyReplacement;
	}

	/**
	 * Flag indicating whether descriptors defined by the Java EE specification will have property replacements applied
	 */
	@SuppressWarnings("unchecked")
	public T specDescriptorPropertyReplacement(Boolean value) {
		this.specDescriptorPropertyReplacement = value;
		return (T) this;
	}

	public EeResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ManagedThreadFactory objects to this subresource
	 * @return this
	 * @param value List of ManagedThreadFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactorys(List<ManagedThreadFactory> value) {
		this.subresources.managedThreadFactorys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ManagedThreadFactory object to the list of subresources
	 * @param value The ManagedThreadFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactory(ManagedThreadFactory value) {
		this.subresources.managedThreadFactorys.add(value);
		return (T) this;
	}

	/**
	 * Add all ContextService objects to this subresource
	 * @return this
	 * @param value List of ContextService objects.
	 */
	@SuppressWarnings("unchecked")
	public T contextServices(List<ContextService> value) {
		this.subresources.contextServices.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ContextService object to the list of subresources
	 * @param value The ContextService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T contextService(ContextService value) {
		this.subresources.contextServices.add(value);
		return (T) this;
	}

	/**
	 * Add all ManagedExecutorService objects to this subresource
	 * @return this
	 * @param value List of ManagedExecutorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorServices(List<ManagedExecutorService> value) {
		this.subresources.managedExecutorServices.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ManagedExecutorService object to the list of subresources
	 * @param value The ManagedExecutorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorService(ManagedExecutorService value) {
		this.subresources.managedExecutorServices.add(value);
		return (T) this;
	}

	/**
	 * Add all ManagedScheduledExecutorService objects to this subresource
	 * @return this
	 * @param value List of ManagedScheduledExecutorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorServices(
			List<ManagedScheduledExecutorService> value) {
		this.subresources.managedScheduledExecutorServices.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ManagedScheduledExecutorService object to the list of subresources
	 * @param value The ManagedScheduledExecutorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorService(
			ManagedScheduledExecutorService value) {
		this.subresources.managedScheduledExecutorServices.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Ee
	 */
	public class EeResources {
		/**
		 * A managed thread factory
		 */
		private List<ManagedThreadFactory> managedThreadFactorys = new java.util.ArrayList<>();
		/**
		 * A context service
		 */
		private List<ContextService> contextServices = new java.util.ArrayList<>();
		/**
		 * A managed executor service
		 */
		private List<ManagedExecutorService> managedExecutorServices = new java.util.ArrayList<>();
		/**
		 * A managed scheduled executor service
		 */
		private List<ManagedScheduledExecutorService> managedScheduledExecutorServices = new java.util.ArrayList<>();

		/**
		 * Get the list of ManagedThreadFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ManagedThreadFactory> managedThreadFactorys() {
			return this.managedThreadFactorys;
		}

		/**
		 * Get the list of ContextService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ContextService> contextServices() {
			return this.contextServices;
		}

		/**
		 * Get the list of ManagedExecutorService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ManagedExecutorService> managedExecutorServices() {
			return this.managedExecutorServices;
		}

		/**
		 * Get the list of ManagedScheduledExecutorService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ManagedScheduledExecutorService> managedScheduledExecutorServices() {
			return this.managedScheduledExecutorServices;
		}
	}

	/**
	 * The JNDI names for the default EE bindings
	 */
	@Subresource
	public DefaultBindings defaultBindings() {
		return this.defaultBindings;
	}

	/**
	 * The JNDI names for the default EE bindings
	 */
	@SuppressWarnings("unchecked")
	public T defaultBindings(DefaultBindings value) {
		this.defaultBindings = value;
		return (T) this;
	}
}