package org.wildfly.swarm.config.ee.subsystem.managedThreadFactory;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A managed thread factory
 */
@Address("/subsystem=ee/managed-thread-factory=*")
public class ManagedThreadFactory<T extends ManagedThreadFactory> {

	private String key;
	private String contextService;
	private String jndiName;
	private Integer priority;

	public ManagedThreadFactory(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the context service to be used by the managed thread factory
	 */
	@ModelNodeBinding(detypedName = "context-service")
	public String contextService() {
		return this.contextService;
	}

	/**
	 * The name of the context service to be used by the managed thread factory
	 */
	@SuppressWarnings("unchecked")
	public T contextService(String value) {
		this.contextService = value;
		return (T) this;
	}

	/**
	 * The JNDI Name to lookup the managed thread factory.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The JNDI Name to lookup the managed thread factory.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * The priority applied to threads created by the factory
	 */
	@ModelNodeBinding(detypedName = "priority")
	public Integer priority() {
		return this.priority;
	}

	/**
	 * The priority applied to threads created by the factory
	 */
	@SuppressWarnings("unchecked")
	public T priority(Integer value) {
		this.priority = value;
		return (T) this;
	}
}