package org.wildfly.swarm.config.ejb3.subsystem.clusterPassivationStore;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A clustered passivation store
 */
@Address("/subsystem=ejb3/cluster-passivation-store=*")
public class ClusterPassivationStore<T extends ClusterPassivationStore> {

	private String key;
	private String beanCache;
	private String cacheContainer;
	private String clientMappingsCache;
	private Long idleTimeout;
	private String idleTimeoutUnit;
	private Integer maxSize;
	private Boolean passivateEventsOnReplicate;

	public ClusterPassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@ModelNodeBinding(detypedName = "bean-cache")
	public String beanCache() {
		return this.beanCache;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@SuppressWarnings("unchecked")
	public T beanCache(String value) {
		this.beanCache = value;
		return (T) this;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@ModelNodeBinding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(String value) {
		this.cacheContainer = value;
		return (T) this;
	}

	/**
	 * The name of the cache used to store client-mappings of the EJB remoting connector's socket-bindings
	 */
	@ModelNodeBinding(detypedName = "client-mappings-cache")
	public String clientMappingsCache() {
		return this.clientMappingsCache;
	}

	/**
	 * The name of the cache used to store client-mappings of the EJB remoting connector's socket-bindings
	 */
	@SuppressWarnings("unchecked")
	public T clientMappingsCache(String value) {
		this.clientMappingsCache = value;
		return (T) this;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@ModelNodeBinding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeout(Long value) {
		this.idleTimeout = value;
		return (T) this;
	}

	/**
	 * The unit of idle-timeout
	 */
	@ModelNodeBinding(detypedName = "idle-timeout-unit")
	public String idleTimeoutUnit() {
		return this.idleTimeoutUnit;
	}

	/**
	 * The unit of idle-timeout
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeoutUnit(String value) {
		this.idleTimeoutUnit = value;
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(Integer value) {
		this.maxSize = value;
		return (T) this;
	}

	/**
	 * Indicates whether replication should trigger passivation events on the bean
	 */
	@ModelNodeBinding(detypedName = "passivate-events-on-replicate")
	public Boolean passivateEventsOnReplicate() {
		return this.passivateEventsOnReplicate;
	}

	/**
	 * Indicates whether replication should trigger passivation events on the bean
	 */
	@SuppressWarnings("unchecked")
	public T passivateEventsOnReplicate(Boolean value) {
		this.passivateEventsOnReplicate = value;
		return (T) this;
	}
}