package org.wildfly.swarm.config.ejb3.subsystem.service;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The EJB3 Asynchronous Invocation Service
 */
@Address("/subsystem=ejb3/service=async")
@Implicit
public class Async<T extends Async> {

	private String key;
	private String threadPoolName;

	public Async() {
		this.key = "async";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	@ModelNodeBinding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolName(String value) {
		this.threadPoolName = value;
		return (T) this;
	}
}