package org.wildfly.swarm.config.ejb3.subsystem.service.channelCreationOptions;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The options that will be used during the EJB remote channel creation
 */
@Address("/subsystem=ejb3/service=remote/channel-creation-options=*")
public class ChannelCreationOptions<T extends ChannelCreationOptions> {

	private String key;
	private String type;
	private String value;

	public ChannelCreationOptions(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The type of the channel creation option
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type of the channel creation option
	 */
	@SuppressWarnings("unchecked")
	public T type(String value) {
		this.type = value;
		return (T) this;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		this.value = value;
		return (T) this;
	}
}