package org.wildfly.swarm.config.jpa;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The configuration of the JPA subsystem.
 */
@Address("/subsystem=jpa")
@Implicit
public class Jpa<T extends Jpa> {

	private String key;
	private String defaultDatasource;
	private String defaultExtendedPersistenceInheritance;

	public Jpa() {
		this.key = "jpa";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the default global datasource.
	 */
	@ModelNodeBinding(detypedName = "default-datasource")
	public String defaultDatasource() {
		return this.defaultDatasource;
	}

	/**
	 * The name of the default global datasource.
	 */
	@SuppressWarnings("unchecked")
	public T defaultDatasource(String value) {
		this.defaultDatasource = value;
		return (T) this;
	}

	/**
	 * Controls how JPA extended persistence context (XPC) inheritance is performed. 'DEEP' shares the extended persistence context at top bean level.  'SHALLOW' the extended persistece context is only shared with the parent bean (never with sibling beans).
	 */
	@ModelNodeBinding(detypedName = "default-extended-persistence-inheritance")
	public String defaultExtendedPersistenceInheritance() {
		return this.defaultExtendedPersistenceInheritance;
	}

	/**
	 * Controls how JPA extended persistence context (XPC) inheritance is performed. 'DEEP' shares the extended persistence context at top bean level.  'SHALLOW' the extended persistece context is only shared with the parent bean (never with sibling beans).
	 */
	@SuppressWarnings("unchecked")
	public T defaultExtendedPersistenceInheritance(String value) {
		this.defaultExtendedPersistenceInheritance = value;
		return (T) this;
	}
}