package org.wildfly.swarm.config.mail;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.mail.subsystem.mailSession.MailSession;
/**
 * The mail subsystem
 */
@Address("/subsystem=mail")
@Implicit
public class Mail<T extends Mail> {

	private String key;
	private MailResources subresources = new MailResources();

	public Mail() {
		this.key = "mail";
	}

	public String getKey() {
		return this.key;
	}

	public MailResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all MailSession objects to this subresource
	 * @return this
	 * @param value List of MailSession objects.
	 */
	@SuppressWarnings("unchecked")
	public T mailSessions(List<MailSession> value) {
		this.subresources.mailSessions.addAll(value);
		return (T) this;
	}

	/**
	 * Add the MailSession object to the list of subresources
	 * @param value The MailSession to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(MailSession value) {
		this.subresources.mailSessions.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Mail
	 */
	public class MailResources {
		/**
		 * Mail session definition
		 */
		private List<MailSession> mailSessions = new java.util.ArrayList<>();

		/**
		 * Get the list of MailSession resources
		 * @return the list of resources
		 */
		@Subresource
		public List<MailSession> mailSessions() {
			return this.mailSessions;
		}
	}
}