package org.wildfly.swarm.config.naming.subsystem.binding;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * JNDI bindings for primitive types
 */
@Address("/subsystem=naming/binding=*")
public class Binding<T extends Binding> {

	private String key;
	private String bindingType;
	private Boolean cache;
	private String attributeClass;
	private Map environment;
	private String lookup;
	private String module;
	private String type;
	private String value;

	public Binding(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The type of binding to create, may be simple, lookup, external-context or object-factory
	 */
	@ModelNodeBinding(detypedName = "binding-type")
	public String bindingType() {
		return this.bindingType;
	}

	/**
	 * The type of binding to create, may be simple, lookup, external-context or object-factory
	 */
	@SuppressWarnings("unchecked")
	public T bindingType(String value) {
		this.bindingType = value;
		return (T) this;
	}

	/**
	 * If the external context should be cached
	 */
	@ModelNodeBinding(detypedName = "cache")
	public Boolean cache() {
		return this.cache;
	}

	/**
	 * If the external context should be cached
	 */
	@SuppressWarnings("unchecked")
	public T cache(Boolean value) {
		this.cache = value;
		return (T) this;
	}

	/**
	 * The object factory class name for object factory bindings
	 */
	@ModelNodeBinding(detypedName = "class")
	public String attributeClass() {
		return this.attributeClass;
	}

	/**
	 * The object factory class name for object factory bindings
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(String value) {
		this.attributeClass = value;
		return (T) this;
	}

	/**
	 * The environment to use on object factory instance retrieval
	 */
	@ModelNodeBinding(detypedName = "environment")
	public Map environment() {
		return this.environment;
	}

	/**
	 * The environment to use on object factory instance retrieval
	 */
	@SuppressWarnings("unchecked")
	public T environment(Map value) {
		this.environment = value;
		return (T) this;
	}

	/**
	 * The entry to lookup in JNDI for lookup bindings
	 */
	@ModelNodeBinding(detypedName = "lookup")
	public String lookup() {
		return this.lookup;
	}

	/**
	 * The entry to lookup in JNDI for lookup bindings
	 */
	@SuppressWarnings("unchecked")
	public T lookup(String value) {
		this.lookup = value;
		return (T) this;
	}

	/**
	 * The module to load the object factory from for object factory bindings
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module to load the object factory from for object factory bindings
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * The type of the value to bind for simple bindings, this must be a primitive type
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type of the value to bind for simple bindings, this must be a primitive type
	 */
	@SuppressWarnings("unchecked")
	public T type(String value) {
		this.type = value;
		return (T) this;
	}

	/**
	 * The value to bind for simple bindings
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value to bind for simple bindings
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		this.value = value;
		return (T) this;
	}
}