package org.wildfly.swarm.config.remoting.subsystem.localOutboundConnection;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.subsystem.localOutboundConnection.property.Property;
/**
 * Remoting outbound connection with an implicit local:// URI scheme.
 */
@Address("/subsystem=remoting/local-outbound-connection=*")
public class LocalOutboundConnection<T extends LocalOutboundConnection> {

	private String key;
	private String outboundSocketBindingRef;
	private LocalOutboundConnectionResources subresources = new LocalOutboundConnectionResources();

	public LocalOutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@SuppressWarnings("unchecked")
	public T outboundSocketBindingRef(String value) {
		this.outboundSocketBindingRef = value;
		return (T) this;
	}

	public LocalOutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * @return this
	 * @param value List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<Property> value) {
		this.subresources.propertys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * @param value The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for LocalOutboundConnection
	 */
	public class LocalOutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}