package org.wildfly.swarm.config.remoting.subsystem.localOutboundConnection.property;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
 */
@Address("/subsystem=remoting/local-outbound-connection=*/property=*")
public class Property<T extends Property> {

	private String key;
	private String value;

	public Property(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The property value.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The property value.
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		this.value = value;
		return (T) this;
	}
}