package org.wildfly.swarm.config.remoting.subsystem.outboundConnection;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.subsystem.outboundConnection.property.Property;
/**
 * Remoting outbound connection.
 */
@Address("/subsystem=remoting/outbound-connection=*")
public class OutboundConnection<T extends OutboundConnection> {

	private String key;
	private String uri;
	private OutboundConnectionResources subresources = new OutboundConnectionResources();

	public OutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The connection URI for the outbound connection.
	 */
	@ModelNodeBinding(detypedName = "uri")
	public String uri() {
		return this.uri;
	}

	/**
	 * The connection URI for the outbound connection.
	 */
	@SuppressWarnings("unchecked")
	public T uri(String value) {
		this.uri = value;
		return (T) this;
	}

	public OutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * @return this
	 * @param value List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<Property> value) {
		this.subresources.propertys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * @param value The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for OutboundConnection
	 */
	public class OutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}