package org.wildfly.swarm.config.remoting.subsystem.remoteOutboundConnection;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.subsystem.remoteOutboundConnection.property.Property;
/**
 * Remoting outbound connection with an implicit remote:// URI scheme.
 */
@Address("/subsystem=remoting/remote-outbound-connection=*")
public class RemoteOutboundConnection<T extends RemoteOutboundConnection> {

	private String key;
	private String outboundSocketBindingRef;
	private String protocol;
	private String securityRealm;
	private String username;
	private RemoteOutboundConnectionResources subresources = new RemoteOutboundConnectionResources();

	public RemoteOutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@SuppressWarnings("unchecked")
	public T outboundSocketBindingRef(String value) {
		this.outboundSocketBindingRef = value;
		return (T) this;
	}

	/**
	 * The protocol to use for the remote connection. Defaults to http-remoting.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The protocol to use for the remote connection. Defaults to http-remoting.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(String value) {
		this.protocol = value;
		return (T) this;
	}

	/**
	 * Reference to the security realm to use to obtain the password and SSL configuration.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * Reference to the security realm to use to obtain the password and SSL configuration.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(String value) {
		this.securityRealm = value;
		return (T) this;
	}

	/**
	 * The user name to use when authenticating against the remote server.
	 */
	@ModelNodeBinding(detypedName = "username")
	public String username() {
		return this.username;
	}

	/**
	 * The user name to use when authenticating against the remote server.
	 */
	@SuppressWarnings("unchecked")
	public T username(String value) {
		this.username = value;
		return (T) this;
	}

	public RemoteOutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * @return this
	 * @param value List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<Property> value) {
		this.subresources.propertys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * @param value The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for RemoteOutboundConnection
	 */
	public class RemoteOutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}