package org.wildfly.swarm.config.transactions.subsystem.commitMarkableResource;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * a CMR resource (i.e. a local resource that can reliably participate in an XA transaction)
 */
@Address("/subsystem=transactions/commit-markable-resource=*")
public class CommitMarkableResource<T extends CommitMarkableResource> {

	private String key;
	private Integer batchSize;
	private Boolean immediateCleanup;
	private String jndiName;
	private String name;

	public CommitMarkableResource(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Batch size for this CMR resource
	 */
	@ModelNodeBinding(detypedName = "batch-size")
	public Integer batchSize() {
		return this.batchSize;
	}

	/**
	 * Batch size for this CMR resource
	 */
	@SuppressWarnings("unchecked")
	public T batchSize(Integer value) {
		this.batchSize = value;
		return (T) this;
	}

	/**
	 * Immediate cleanup associated to this CMR resource
	 */
	@ModelNodeBinding(detypedName = "immediate-cleanup")
	public Boolean immediateCleanup() {
		return this.immediateCleanup;
	}

	/**
	 * Immediate cleanup associated to this CMR resource
	 */
	@SuppressWarnings("unchecked")
	public T immediateCleanup(Boolean value) {
		this.immediateCleanup = value;
		return (T) this;
	}

	/**
	 * JNDi name of this CMR resource
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * JNDi name of this CMR resource
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * table name for storing XIDs
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * table name for storing XIDs
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		this.name = value;
		return (T) this;
	}
}