package org.wildfly.swarm.config.transactions.subsystem.logStore;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.subsystem.logStore.transactions.Transactions;
/**
 * Representation of the transaction logging storage mechanism.
 */
@Address("/subsystem=transactions/log-store=log-store")
@Implicit
public class LogStore<T extends LogStore> {

	private String key;
	private Boolean exposeAllLogs;
	private String type;
	private LogStoreResources subresources = new LogStoreResources();

	public LogStore() {
		this.key = "log-store";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether to expose all logs like orphans etc. By default only a subset of transaction logs is exposed.
	 */
	@ModelNodeBinding(detypedName = "expose-all-logs")
	public Boolean exposeAllLogs() {
		return this.exposeAllLogs;
	}

	/**
	 * Whether to expose all logs like orphans etc. By default only a subset of transaction logs is exposed.
	 */
	@SuppressWarnings("unchecked")
	public T exposeAllLogs(Boolean value) {
		this.exposeAllLogs = value;
		return (T) this;
	}

	/**
	 * Specifies the implementation type of the logging store.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * Specifies the implementation type of the logging store.
	 */
	@SuppressWarnings("unchecked")
	public T type(String value) {
		this.type = value;
		return (T) this;
	}

	public LogStoreResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Transactions objects to this subresource
	 * @return this
	 * @param value List of Transactions objects.
	 */
	@SuppressWarnings("unchecked")
	public T transactions(List<Transactions> value) {
		this.subresources.transactions.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Transactions object to the list of subresources
	 * @param value The Transactions to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T transactions(Transactions value) {
		this.subresources.transactions.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for LogStore
	 */
	public class LogStoreResources {
		/**
		 * The persistent information that the transaction manager stores for the purpose of recovering a transaction in the event of failure. The probe operation will add and remove transactions from the model as the corresponding real transactions start and finish the prepare and commit phases. A stuck transaction will remain in the model until either it is completed or explicitly removed by the delete operation.
		 */
		private List<Transactions> transactions = new java.util.ArrayList<>();

		/**
		 * Get the list of Transactions resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Transactions> transactions() {
			return this.transactions;
		}
	}
}