package org.wildfly.swarm.config.undertow.subsystem.configuration;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.configuration.errorPage.ErrorPage;
import org.wildfly.swarm.config.undertow.subsystem.configuration.customFilter.CustomFilter;
import org.wildfly.swarm.config.undertow.subsystem.configuration.gzip.Gzip;
import org.wildfly.swarm.config.undertow.subsystem.configuration.modCluster.ModCluster;
import org.wildfly.swarm.config.undertow.subsystem.configuration.expressionFilter.ExpressionFilter;
import org.wildfly.swarm.config.undertow.subsystem.configuration.responseHeader.ResponseHeader;
import org.wildfly.swarm.config.undertow.subsystem.configuration.rewrite.Rewrite;
import org.wildfly.swarm.config.undertow.subsystem.configuration.connectionLimit.ConnectionLimit;
/**
 * Undertow filters
 */
@Address("/subsystem=undertow/configuration=filter")
@Implicit
public class Filter<T extends Filter> {

	private String key;
	private FilterResources subresources = new FilterResources();

	public Filter() {
		this.key = "filter";
	}

	public String getKey() {
		return this.key;
	}

	public FilterResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ErrorPage objects to this subresource
	 * @return this
	 * @param value List of ErrorPage objects.
	 */
	@SuppressWarnings("unchecked")
	public T errorPages(List<ErrorPage> value) {
		this.subresources.errorPages.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ErrorPage object to the list of subresources
	 * @param value The ErrorPage to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T errorPage(ErrorPage value) {
		this.subresources.errorPages.add(value);
		return (T) this;
	}

	/**
	 * Add all CustomFilter objects to this subresource
	 * @return this
	 * @param value List of CustomFilter objects.
	 */
	@SuppressWarnings("unchecked")
	public T customFilters(List<CustomFilter> value) {
		this.subresources.customFilters.addAll(value);
		return (T) this;
	}

	/**
	 * Add the CustomFilter object to the list of subresources
	 * @param value The CustomFilter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customFilter(CustomFilter value) {
		this.subresources.customFilters.add(value);
		return (T) this;
	}

	/**
	 * Add all Gzip objects to this subresource
	 * @return this
	 * @param value List of Gzip objects.
	 */
	@SuppressWarnings("unchecked")
	public T gzips(List<Gzip> value) {
		this.subresources.gzips.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Gzip object to the list of subresources
	 * @param value The Gzip to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T gzip(Gzip value) {
		this.subresources.gzips.add(value);
		return (T) this;
	}

	/**
	 * Add all ModCluster objects to this subresource
	 * @return this
	 * @param value List of ModCluster objects.
	 */
	@SuppressWarnings("unchecked")
	public T modClusters(List<ModCluster> value) {
		this.subresources.modClusters.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ModCluster object to the list of subresources
	 * @param value The ModCluster to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T modCluster(ModCluster value) {
		this.subresources.modClusters.add(value);
		return (T) this;
	}

	/**
	 * Add all ExpressionFilter objects to this subresource
	 * @return this
	 * @param value List of ExpressionFilter objects.
	 */
	@SuppressWarnings("unchecked")
	public T expressionFilters(List<ExpressionFilter> value) {
		this.subresources.expressionFilters.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ExpressionFilter object to the list of subresources
	 * @param value The ExpressionFilter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T expressionFilter(ExpressionFilter value) {
		this.subresources.expressionFilters.add(value);
		return (T) this;
	}

	/**
	 * Add all ResponseHeader objects to this subresource
	 * @return this
	 * @param value List of ResponseHeader objects.
	 */
	@SuppressWarnings("unchecked")
	public T responseHeaders(List<ResponseHeader> value) {
		this.subresources.responseHeaders.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ResponseHeader object to the list of subresources
	 * @param value The ResponseHeader to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T responseHeader(ResponseHeader value) {
		this.subresources.responseHeaders.add(value);
		return (T) this;
	}

	/**
	 * Add all Rewrite objects to this subresource
	 * @return this
	 * @param value List of Rewrite objects.
	 */
	@SuppressWarnings("unchecked")
	public T rewrites(List<Rewrite> value) {
		this.subresources.rewrites.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Rewrite object to the list of subresources
	 * @param value The Rewrite to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T rewrite(Rewrite value) {
		this.subresources.rewrites.add(value);
		return (T) this;
	}

	/**
	 * Add all ConnectionLimit objects to this subresource
	 * @return this
	 * @param value List of ConnectionLimit objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectionLimits(List<ConnectionLimit> value) {
		this.subresources.connectionLimits.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ConnectionLimit object to the list of subresources
	 * @param value The ConnectionLimit to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionLimit(ConnectionLimit value) {
		this.subresources.connectionLimits.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Filter
	 */
	public class FilterResources {
		/**
		 * The error pages
		 */
		private List<ErrorPage> errorPages = new java.util.ArrayList<>();
		/**
		 * Custom filter
		 */
		private List<CustomFilter> customFilters = new java.util.ArrayList<>();
		/**
		 * Defines gzip filter
		 */
		private List<Gzip> gzips = new java.util.ArrayList<>();
		/**
		 * A mod-cluster front end load balancer
		 */
		private List<ModCluster> modClusters = new java.util.ArrayList<>();
		/**
		 * A filter parsed from the undertow expression language
		 */
		private List<ExpressionFilter> expressionFilters = new java.util.ArrayList<>();
		/**
		 * Response header filter allows you to add custom headers.
		 */
		private List<ResponseHeader> responseHeaders = new java.util.ArrayList<>();
		/**
		 * A rewrite (or redirect) filter
		 */
		private List<Rewrite> rewrites = new java.util.ArrayList<>();
		/**
		 * Connection limiter handler
		 */
		private List<ConnectionLimit> connectionLimits = new java.util.ArrayList<>();

		/**
		 * Get the list of ErrorPage resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ErrorPage> errorPages() {
			return this.errorPages;
		}

		/**
		 * Get the list of CustomFilter resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomFilter> customFilters() {
			return this.customFilters;
		}

		/**
		 * Get the list of Gzip resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Gzip> gzips() {
			return this.gzips;
		}

		/**
		 * Get the list of ModCluster resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ModCluster> modClusters() {
			return this.modClusters;
		}

		/**
		 * Get the list of ExpressionFilter resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ExpressionFilter> expressionFilters() {
			return this.expressionFilters;
		}

		/**
		 * Get the list of ResponseHeader resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ResponseHeader> responseHeaders() {
			return this.responseHeaders;
		}

		/**
		 * Get the list of Rewrite resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Rewrite> rewrites() {
			return this.rewrites;
		}

		/**
		 * Get the list of ConnectionLimit resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionLimit> connectionLimits() {
			return this.connectionLimits;
		}
	}
}