package org.wildfly.swarm.config.undertow.subsystem.configuration;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.configuration.reverseProxy.ReverseProxy;
import org.wildfly.swarm.config.undertow.subsystem.configuration.file.File;
/**
 * Undertow handlers
 */
@Address("/subsystem=undertow/configuration=handler")
@Implicit
public class Handler<T extends Handler> {

	private String key;
	private HandlerResources subresources = new HandlerResources();

	public Handler() {
		this.key = "handler";
	}

	public String getKey() {
		return this.key;
	}

	public HandlerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ReverseProxy objects to this subresource
	 * @return this
	 * @param value List of ReverseProxy objects.
	 */
	@SuppressWarnings("unchecked")
	public T reverseProxys(List<ReverseProxy> value) {
		this.subresources.reverseProxys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ReverseProxy object to the list of subresources
	 * @param value The ReverseProxy to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T reverseProxy(ReverseProxy value) {
		this.subresources.reverseProxys.add(value);
		return (T) this;
	}

	/**
	 * Add all File objects to this subresource
	 * @return this
	 * @param value List of File objects.
	 */
	@SuppressWarnings("unchecked")
	public T files(List<File> value) {
		this.subresources.files.addAll(value);
		return (T) this;
	}

	/**
	 * Add the File object to the list of subresources
	 * @param value The File to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T file(File value) {
		this.subresources.files.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Handler
	 */
	public class HandlerResources {
		/**
		 * A reverse proxy handler
		 */
		private List<ReverseProxy> reverseProxys = new java.util.ArrayList<>();
		/**
		 * File handler
		 */
		private List<File> files = new java.util.ArrayList<>();

		/**
		 * Get the list of ReverseProxy resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ReverseProxy> reverseProxys() {
			return this.reverseProxys;
		}

		/**
		 * Get the list of File resources
		 * @return the list of resources
		 */
		@Subresource
		public List<File> files() {
			return this.files;
		}
	}
}