package org.wildfly.swarm.config.undertow.subsystem.configuration.customFilter;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Custom filter
 */
@Address("/subsystem=undertow/configuration=filter/custom-filter=*")
public class CustomFilter<T extends CustomFilter> {

	private String key;
	private String className;
	private String module;
	private Map parameters;

	public CustomFilter(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of HttpHandler
	 */
	@ModelNodeBinding(detypedName = "class-name")
	public String className() {
		return this.className;
	}

	/**
	 * Class name of HttpHandler
	 */
	@SuppressWarnings("unchecked")
	public T className(String value) {
		this.className = value;
		return (T) this;
	}

	/**
	 * Module name where class can be loaded from
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Module name where class can be loaded from
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * Filter parameters
	 */
	@ModelNodeBinding(detypedName = "parameters")
	public Map parameters() {
		return this.parameters;
	}

	/**
	 * Filter parameters
	 */
	@SuppressWarnings("unchecked")
	public T parameters(Map value) {
		this.parameters = value;
		return (T) this;
	}
}