package org.wildfly.swarm.config.undertow.subsystem.configuration.modCluster.balancer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.configuration.modCluster.balancer.node.Node;
import org.wildfly.swarm.config.undertow.subsystem.configuration.modCluster.balancer.loadBalancingGroup.LoadBalancingGroup;
/**
 * Runtime representation of a mod_cluster balancer
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*")
public class Balancer<T extends Balancer> {

	private String key;
	private Integer maxAttempts;
	private Boolean stickySession;
	private String stickySessionCookie;
	private Boolean stickySessionForce;
	private String stickySessionPath;
	private Boolean stickySessionRemove;
	private Integer waitWorker;
	private BalancerResources subresources = new BalancerResources();

	public Balancer(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of attempts to send the request to a backend server
	 */
	@ModelNodeBinding(detypedName = "max-attempts")
	public Integer maxAttempts() {
		return this.maxAttempts;
	}

	/**
	 * The number of attempts to send the request to a backend server
	 */
	@SuppressWarnings("unchecked")
	public T maxAttempts(Integer value) {
		this.maxAttempts = value;
		return (T) this;
	}

	/**
	 * If sticky sessions are enabled
	 */
	@ModelNodeBinding(detypedName = "sticky-session")
	public Boolean stickySession() {
		return this.stickySession;
	}

	/**
	 * If sticky sessions are enabled
	 */
	@SuppressWarnings("unchecked")
	public T stickySession(Boolean value) {
		this.stickySession = value;
		return (T) this;
	}

	/**
	 * The session cookie name
	 */
	@ModelNodeBinding(detypedName = "sticky-session-cookie")
	public String stickySessionCookie() {
		return this.stickySessionCookie;
	}

	/**
	 * The session cookie name
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionCookie(String value) {
		this.stickySessionCookie = value;
		return (T) this;
	}

	/**
	 * If this is true then an error will be returned if the request cannot be routed to the sticky node, otherwise it will be routed to another node
	 */
	@ModelNodeBinding(detypedName = "sticky-session-force")
	public Boolean stickySessionForce() {
		return this.stickySessionForce;
	}

	/**
	 * If this is true then an error will be returned if the request cannot be routed to the sticky node, otherwise it will be routed to another node
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionForce(Boolean value) {
		this.stickySessionForce = value;
		return (T) this;
	}

	/**
	 * The path of the sticky session cookie
	 */
	@ModelNodeBinding(detypedName = "sticky-session-path")
	public String stickySessionPath() {
		return this.stickySessionPath;
	}

	/**
	 * The path of the sticky session cookie
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionPath(String value) {
		this.stickySessionPath = value;
		return (T) this;
	}

	/**
	 * Remove the session cookie if the request cannot be routed to the correct host
	 */
	@ModelNodeBinding(detypedName = "sticky-session-remove")
	public Boolean stickySessionRemove() {
		return this.stickySessionRemove;
	}

	/**
	 * Remove the session cookie if the request cannot be routed to the correct host
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionRemove(Boolean value) {
		this.stickySessionRemove = value;
		return (T) this;
	}

	/**
	 * The number of seconds to wait for an available worker
	 */
	@ModelNodeBinding(detypedName = "wait-worker")
	public Integer waitWorker() {
		return this.waitWorker;
	}

	/**
	 * The number of seconds to wait for an available worker
	 */
	@SuppressWarnings("unchecked")
	public T waitWorker(Integer value) {
		this.waitWorker = value;
		return (T) this;
	}

	public BalancerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Node objects to this subresource
	 * @return this
	 * @param value List of Node objects.
	 */
	@SuppressWarnings("unchecked")
	public T nodes(List<Node> value) {
		this.subresources.nodes.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Node object to the list of subresources
	 * @param value The Node to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T node(Node value) {
		this.subresources.nodes.add(value);
		return (T) this;
	}

	/**
	 * Add all LoadBalancingGroup objects to this subresource
	 * @return this
	 * @param value List of LoadBalancingGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroups(List<LoadBalancingGroup> value) {
		this.subresources.loadBalancingGroups.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LoadBalancingGroup object to the list of subresources
	 * @param value The LoadBalancingGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(LoadBalancingGroup value) {
		this.subresources.loadBalancingGroups.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Balancer
	 */
	public class BalancerResources {
		/**
		 * Runtime representation of a mod_cluster node
		 */
		private List<Node> nodes = new java.util.ArrayList<>();
		/**
		 * A load balancing group
		 */
		private List<LoadBalancingGroup> loadBalancingGroups = new java.util.ArrayList<>();

		/**
		 * Get the list of Node resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Node> nodes() {
			return this.nodes;
		}

		/**
		 * Get the list of LoadBalancingGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoadBalancingGroup> loadBalancingGroups() {
			return this.loadBalancingGroups;
		}
	}
}