package org.wildfly.swarm.config.undertow.subsystem.configuration.modCluster.balancer.node;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.configuration.modCluster.balancer.node.context.Context;
/**
 * Runtime representation of a mod_cluster node
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*/node=*")
public class Node<T extends Node> {

	private String key;
	private List<String> aliases;
	private Integer cacheConnections;
	private Integer elected;
	private Boolean flushPackets;
	private Integer load;
	private String loadBalancingGroup;
	private Integer maxConnections;
	private Integer openConnections;
	private Integer ping;
	private Boolean queueNewRequests;
	private Long read;
	private Integer requestQueueSize;
	private String status;
	private Integer timeout;
	private Long ttl;
	private String uri;
	private Long written;
	private NodeResources subresources = new NodeResources();

	public Node(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The nodes aliases
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The nodes aliases
	 */
	@SuppressWarnings("unchecked")
	public T aliases(List<String> value) {
		this.aliases = value;
		return (T) this;
	}

	/**
	 * The number of connections to keep alive indefinitely
	 */
	@ModelNodeBinding(detypedName = "cache-connections")
	public Integer cacheConnections() {
		return this.cacheConnections;
	}

	/**
	 * The number of connections to keep alive indefinitely
	 */
	@SuppressWarnings("unchecked")
	public T cacheConnections(Integer value) {
		this.cacheConnections = value;
		return (T) this;
	}

	/**
	 * The elected count
	 */
	@ModelNodeBinding(detypedName = "elected")
	public Integer elected() {
		return this.elected;
	}

	/**
	 * The elected count
	 */
	@SuppressWarnings("unchecked")
	public T elected(Integer value) {
		this.elected = value;
		return (T) this;
	}

	/**
	 * If received data should be immediately flushed
	 */
	@ModelNodeBinding(detypedName = "flush-packets")
	public Boolean flushPackets() {
		return this.flushPackets;
	}

	/**
	 * If received data should be immediately flushed
	 */
	@SuppressWarnings("unchecked")
	public T flushPackets(Boolean value) {
		this.flushPackets = value;
		return (T) this;
	}

	/**
	 * The current load of this node
	 */
	@ModelNodeBinding(detypedName = "load")
	public Integer load() {
		return this.load;
	}

	/**
	 * The current load of this node
	 */
	@SuppressWarnings("unchecked")
	public T load(Integer value) {
		this.load = value;
		return (T) this;
	}

	/**
	 * The load balancing group this node belongs to
	 */
	@ModelNodeBinding(detypedName = "load-balancing-group")
	public String loadBalancingGroup() {
		return this.loadBalancingGroup;
	}

	/**
	 * The load balancing group this node belongs to
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(String value) {
		this.loadBalancingGroup = value;
		return (T) this;
	}

	/**
	 * The maximum number of connections per IO thread
	 */
	@ModelNodeBinding(detypedName = "max-connections")
	public Integer maxConnections() {
		return this.maxConnections;
	}

	/**
	 * The maximum number of connections per IO thread
	 */
	@SuppressWarnings("unchecked")
	public T maxConnections(Integer value) {
		this.maxConnections = value;
		return (T) this;
	}

	/**
	 * The current number of open connections
	 */
	@ModelNodeBinding(detypedName = "open-connections")
	public Integer openConnections() {
		return this.openConnections;
	}

	/**
	 * The current number of open connections
	 */
	@SuppressWarnings("unchecked")
	public T openConnections(Integer value) {
		this.openConnections = value;
		return (T) this;
	}

	/**
	 * The nodes ping
	 */
	@ModelNodeBinding(detypedName = "ping")
	public Integer ping() {
		return this.ping;
	}

	/**
	 * The nodes ping
	 */
	@SuppressWarnings("unchecked")
	public T ping(Integer value) {
		this.ping = value;
		return (T) this;
	}

	/**
	 * If a request is received and there is no worker immediately available should it be queued
	 */
	@ModelNodeBinding(detypedName = "queue-new-requests")
	public Boolean queueNewRequests() {
		return this.queueNewRequests;
	}

	/**
	 * If a request is received and there is no worker immediately available should it be queued
	 */
	@SuppressWarnings("unchecked")
	public T queueNewRequests(Boolean value) {
		this.queueNewRequests = value;
		return (T) this;
	}

	/**
	 * The number of bytes read from the node
	 */
	@ModelNodeBinding(detypedName = "read")
	public Long read() {
		return this.read;
	}

	/**
	 * The number of bytes read from the node
	 */
	@SuppressWarnings("unchecked")
	public T read(Long value) {
		this.read = value;
		return (T) this;
	}

	/**
	 * The size of the request queue
	 */
	@ModelNodeBinding(detypedName = "request-queue-size")
	public Integer requestQueueSize() {
		return this.requestQueueSize;
	}

	/**
	 * The size of the request queue
	 */
	@SuppressWarnings("unchecked")
	public T requestQueueSize(Integer value) {
		this.requestQueueSize = value;
		return (T) this;
	}

	/**
	 * The current status of this node
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * The current status of this node
	 */
	@SuppressWarnings("unchecked")
	public T status(String value) {
		this.status = value;
		return (T) this;
	}

	/**
	 * The request timeout
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Integer timeout() {
		return this.timeout;
	}

	/**
	 * The request timeout
	 */
	@SuppressWarnings("unchecked")
	public T timeout(Integer value) {
		this.timeout = value;
		return (T) this;
	}

	/**
	 * The time connections will stay alive with no requests before being closed, if the number of connections is larger than cache-connections
	 */
	@ModelNodeBinding(detypedName = "ttl")
	public Long ttl() {
		return this.ttl;
	}

	/**
	 * The time connections will stay alive with no requests before being closed, if the number of connections is larger than cache-connections
	 */
	@SuppressWarnings("unchecked")
	public T ttl(Long value) {
		this.ttl = value;
		return (T) this;
	}

	/**
	 * The URI that the load balancer uses to connect to the node
	 */
	@ModelNodeBinding(detypedName = "uri")
	public String uri() {
		return this.uri;
	}

	/**
	 * The URI that the load balancer uses to connect to the node
	 */
	@SuppressWarnings("unchecked")
	public T uri(String value) {
		this.uri = value;
		return (T) this;
	}

	/**
	 * The number of bytes transferred to the node
	 */
	@ModelNodeBinding(detypedName = "written")
	public Long written() {
		return this.written;
	}

	/**
	 * The number of bytes transferred to the node
	 */
	@SuppressWarnings("unchecked")
	public T written(Long value) {
		this.written = value;
		return (T) this;
	}

	public NodeResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Context objects to this subresource
	 * @return this
	 * @param value List of Context objects.
	 */
	@SuppressWarnings("unchecked")
	public T contexts(List<Context> value) {
		this.subresources.contexts.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Context object to the list of subresources
	 * @param value The Context to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T context(Context value) {
		this.subresources.contexts.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Node
	 */
	public class NodeResources {
		/**
		 * Runtime representation of a mod_cluster context
		 */
		private List<Context> contexts = new java.util.ArrayList<>();

		/**
		 * Get the list of Context resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Context> contexts() {
			return this.contexts;
		}
	}
}