package org.wildfly.swarm.config.undertow.subsystem.configuration.responseHeader;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Response header filter allows you to add custom headers.
 */
@Address("/subsystem=undertow/configuration=filter/response-header=*")
public class ResponseHeader<T extends ResponseHeader> {

	private String key;
	private String headerName;
	private String headerValue;

	public ResponseHeader(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Header name
	 */
	@ModelNodeBinding(detypedName = "header-name")
	public String headerName() {
		return this.headerName;
	}

	/**
	 * Header name
	 */
	@SuppressWarnings("unchecked")
	public T headerName(String value) {
		this.headerName = value;
		return (T) this;
	}

	/**
	 * Value for header
	 */
	@ModelNodeBinding(detypedName = "header-value")
	public String headerValue() {
		return this.headerValue;
	}

	/**
	 * Value for header
	 */
	@SuppressWarnings("unchecked")
	public T headerValue(String value) {
		this.headerValue = value;
		return (T) this;
	}
}