package org.wildfly.swarm.config.undertow.subsystem.server.host.location;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.server.host.location.filterRef.FilterRef;
/**
 * Holds configuration of location resource
 */
@Address("/subsystem=undertow/server=*/host=*/location=*")
public class Location<T extends Location> {

	private String key;
	private String handler;
	private LocationResources subresources = new LocationResources();

	public Location(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Default handler for this location
	 */
	@ModelNodeBinding(detypedName = "handler")
	public String handler() {
		return this.handler;
	}

	/**
	 * Default handler for this location
	 */
	@SuppressWarnings("unchecked")
	public T handler(String value) {
		this.handler = value;
		return (T) this;
	}

	public LocationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all FilterRef objects to this subresource
	 * @return this
	 * @param value List of FilterRef objects.
	 */
	@SuppressWarnings("unchecked")
	public T filterRefs(List<FilterRef> value) {
		this.subresources.filterRefs.addAll(value);
		return (T) this;
	}

	/**
	 * Add the FilterRef object to the list of subresources
	 * @param value The FilterRef to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(FilterRef value) {
		this.subresources.filterRefs.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Location
	 */
	public class LocationResources {
		/**
		 * Reference to filter
		 */
		private List<FilterRef> filterRefs = new java.util.ArrayList<>();

		/**
		 * Get the list of FilterRef resources
		 * @return the list of resources
		 */
		@Subresource
		public List<FilterRef> filterRefs() {
			return this.filterRefs;
		}
	}
}