package org.wildfly.swarm.config.undertow.subsystem.servletContainer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.servletContainer.mimeMapping.MimeMapping;
import org.wildfly.swarm.config.undertow.subsystem.servletContainer.welcomeFile.WelcomeFile;
import org.wildfly.swarm.config.undertow.subsystem.servletContainer.setting.PersistentSessions;
import org.wildfly.swarm.config.undertow.subsystem.servletContainer.setting.Jsp;
import org.wildfly.swarm.config.undertow.subsystem.servletContainer.setting.Websockets;
import org.wildfly.swarm.config.undertow.subsystem.servletContainer.setting.SessionCookie;
/**
 * A servlet container
 */
@Address("/subsystem=undertow/servlet-container=*")
public class ServletContainer<T extends ServletContainer> {

	private String key;
	private Boolean allowNonStandardWrappers;
	private String defaultBufferCache;
	private String defaultEncoding;
	private Integer defaultSessionTimeout;
	private Boolean directoryListing;
	private Boolean disableCachingForSecuredPages;
	private Boolean eagerFilterInitialization;
	private Boolean ignoreFlush;
	private Boolean proactiveAuthentication;
	private Integer sessionIdLength;
	private String stackTraceOnError;
	private Boolean useListenerEncoding;
	private ServletContainerResources subresources = new ServletContainerResources();
	private PersistentSessions persistentSessions;
	private Jsp jsp;
	private Websockets websockets;
	private SessionCookie sessionCookie;

	public ServletContainer(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If true then request and response wrappers that do not extend the standard wrapper classes can be used
	 */
	@ModelNodeBinding(detypedName = "allow-non-standard-wrappers")
	public Boolean allowNonStandardWrappers() {
		return this.allowNonStandardWrappers;
	}

	/**
	 * If true then request and response wrappers that do not extend the standard wrapper classes can be used
	 */
	@SuppressWarnings("unchecked")
	public T allowNonStandardWrappers(Boolean value) {
		this.allowNonStandardWrappers = value;
		return (T) this;
	}

	/**
	 * The buffer cache to use for caching static resources
	 */
	@ModelNodeBinding(detypedName = "default-buffer-cache")
	public String defaultBufferCache() {
		return this.defaultBufferCache;
	}

	/**
	 * The buffer cache to use for caching static resources
	 */
	@SuppressWarnings("unchecked")
	public T defaultBufferCache(String value) {
		this.defaultBufferCache = value;
		return (T) this;
	}

	/**
	 * Default encoding to use for all deployed applications
	 */
	@ModelNodeBinding(detypedName = "default-encoding")
	public String defaultEncoding() {
		return this.defaultEncoding;
	}

	/**
	 * Default encoding to use for all deployed applications
	 */
	@SuppressWarnings("unchecked")
	public T defaultEncoding(String value) {
		this.defaultEncoding = value;
		return (T) this;
	}

	/**
	 * The default session timeout (in minutes) for all applications deployed in the container.
	 */
	@ModelNodeBinding(detypedName = "default-session-timeout")
	public Integer defaultSessionTimeout() {
		return this.defaultSessionTimeout;
	}

	/**
	 * The default session timeout (in minutes) for all applications deployed in the container.
	 */
	@SuppressWarnings("unchecked")
	public T defaultSessionTimeout(Integer value) {
		this.defaultSessionTimeout = value;
		return (T) this;
	}

	/**
	 * If directory listing should be enabled for default servlets.
	 */
	@ModelNodeBinding(detypedName = "directory-listing")
	public Boolean directoryListing() {
		return this.directoryListing;
	}

	/**
	 * If directory listing should be enabled for default servlets.
	 */
	@SuppressWarnings("unchecked")
	public T directoryListing(Boolean value) {
		this.directoryListing = value;
		return (T) this;
	}

	/**
	 * If Undertow should set headers to disable caching for secured paged. Disabling this can cause security problems, as sensitive pages may be cached by an intermediary.
	 */
	@ModelNodeBinding(detypedName = "disable-caching-for-secured-pages")
	public Boolean disableCachingForSecuredPages() {
		return this.disableCachingForSecuredPages;
	}

	/**
	 * If Undertow should set headers to disable caching for secured paged. Disabling this can cause security problems, as sensitive pages may be cached by an intermediary.
	 */
	@SuppressWarnings("unchecked")
	public T disableCachingForSecuredPages(Boolean value) {
		this.disableCachingForSecuredPages = value;
		return (T) this;
	}

	/**
	 * If true undertow calls filter init() on deployment start rather than when first requested.
	 */
	@ModelNodeBinding(detypedName = "eager-filter-initialization")
	public Boolean eagerFilterInitialization() {
		return this.eagerFilterInitialization;
	}

	/**
	 * If true undertow calls filter init() on deployment start rather than when first requested.
	 */
	@SuppressWarnings("unchecked")
	public T eagerFilterInitialization(Boolean value) {
		this.eagerFilterInitialization = value;
		return (T) this;
	}

	/**
	 * Ignore flushes on the servlet output stream. In most cases these just hurt performance for no good reason.
	 */
	@ModelNodeBinding(detypedName = "ignore-flush")
	public Boolean ignoreFlush() {
		return this.ignoreFlush;
	}

	/**
	 * Ignore flushes on the servlet output stream. In most cases these just hurt performance for no good reason.
	 */
	@SuppressWarnings("unchecked")
	public T ignoreFlush(Boolean value) {
		this.ignoreFlush = value;
		return (T) this;
	}

	/**
	 * If proactive authentication should be used. If this is true a user will always be authenticated if credentials are present.
	 */
	@ModelNodeBinding(detypedName = "proactive-authentication")
	public Boolean proactiveAuthentication() {
		return this.proactiveAuthentication;
	}

	/**
	 * If proactive authentication should be used. If this is true a user will always be authenticated if credentials are present.
	 */
	@SuppressWarnings("unchecked")
	public T proactiveAuthentication(Boolean value) {
		this.proactiveAuthentication = value;
		return (T) this;
	}

	/**
	 * The length of the generated session ID. Longer session ID's are more secure.
	 */
	@ModelNodeBinding(detypedName = "session-id-length")
	public Integer sessionIdLength() {
		return this.sessionIdLength;
	}

	/**
	 * The length of the generated session ID. Longer session ID's are more secure.
	 */
	@SuppressWarnings("unchecked")
	public T sessionIdLength(Integer value) {
		this.sessionIdLength = value;
		return (T) this;
	}

	/**
	 * If an error page with the stack trace should be generated on error. Values are all, none and local-only
	 */
	@ModelNodeBinding(detypedName = "stack-trace-on-error")
	public String stackTraceOnError() {
		return this.stackTraceOnError;
	}

	/**
	 * If an error page with the stack trace should be generated on error. Values are all, none and local-only
	 */
	@SuppressWarnings("unchecked")
	public T stackTraceOnError(String value) {
		this.stackTraceOnError = value;
		return (T) this;
	}

	/**
	 * Use encoding defined on listener
	 */
	@ModelNodeBinding(detypedName = "use-listener-encoding")
	public Boolean useListenerEncoding() {
		return this.useListenerEncoding;
	}

	/**
	 * Use encoding defined on listener
	 */
	@SuppressWarnings("unchecked")
	public T useListenerEncoding(Boolean value) {
		this.useListenerEncoding = value;
		return (T) this;
	}

	public ServletContainerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all MimeMapping objects to this subresource
	 * @return this
	 * @param value List of MimeMapping objects.
	 */
	@SuppressWarnings("unchecked")
	public T mimeMappings(List<MimeMapping> value) {
		this.subresources.mimeMappings.addAll(value);
		return (T) this;
	}

	/**
	 * Add the MimeMapping object to the list of subresources
	 * @param value The MimeMapping to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(MimeMapping value) {
		this.subresources.mimeMappings.add(value);
		return (T) this;
	}

	/**
	 * Add all WelcomeFile objects to this subresource
	 * @return this
	 * @param value List of WelcomeFile objects.
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFiles(List<WelcomeFile> value) {
		this.subresources.welcomeFiles.addAll(value);
		return (T) this;
	}

	/**
	 * Add the WelcomeFile object to the list of subresources
	 * @param value The WelcomeFile to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(WelcomeFile value) {
		this.subresources.welcomeFiles.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for ServletContainer
	 */
	public class ServletContainerResources {
		/**
		 * The servlet container mime mapping config
		 */
		private List<MimeMapping> mimeMappings = new java.util.ArrayList<>();
		/**
		 * The welcome file
		 */
		private List<WelcomeFile> welcomeFiles = new java.util.ArrayList<>();

		/**
		 * Get the list of MimeMapping resources
		 * @return the list of resources
		 */
		@Subresource
		public List<MimeMapping> mimeMappings() {
			return this.mimeMappings;
		}

		/**
		 * Get the list of WelcomeFile resources
		 * @return the list of resources
		 */
		@Subresource
		public List<WelcomeFile> welcomeFiles() {
			return this.welcomeFiles;
		}
	}

	/**
	 * Session persistence sessions
	 */
	@Subresource
	public PersistentSessions persistentSessions() {
		return this.persistentSessions;
	}

	/**
	 * Session persistence sessions
	 */
	@SuppressWarnings("unchecked")
	public T persistentSessions(PersistentSessions value) {
		this.persistentSessions = value;
		return (T) this;
	}

	/**
	 * JSP container configuration.
	 */
	@Subresource
	public Jsp jsp() {
		return this.jsp;
	}

	/**
	 * JSP container configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jsp(Jsp value) {
		this.jsp = value;
		return (T) this;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@Subresource
	public Websockets websockets() {
		return this.websockets;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@SuppressWarnings("unchecked")
	public T websockets(Websockets value) {
		this.websockets = value;
		return (T) this;
	}

	/**
	 * Session cookie configuration
	 */
	@Subresource
	public SessionCookie sessionCookie() {
		return this.sessionCookie;
	}

	/**
	 * Session cookie configuration
	 */
	@SuppressWarnings("unchecked")
	public T sessionCookie(SessionCookie value) {
		this.sessionCookie = value;
		return (T) this;
	}
}